/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jniinchi;

import net.sf.jniinchi.INCHI_PARITY;
import net.sf.jniinchi.INCHI_STEREOTYPE;
import net.sf.jniinchi.JniInchiAtom;

public class JniInchiStereo0D {
    public static final int NO_ATOM = -1;
    private JniInchiAtom[] neighbors = new JniInchiAtom[4];
    private JniInchiAtom centralAtom;
    private INCHI_STEREOTYPE type;
    private INCHI_PARITY parity;
    private INCHI_PARITY disconParity = INCHI_PARITY.NONE;

    public JniInchiStereo0D(JniInchiAtom atC, JniInchiAtom at0, JniInchiAtom at1, JniInchiAtom at2, JniInchiAtom at3, INCHI_STEREOTYPE type, INCHI_PARITY parity) {
        this.centralAtom = atC;
        this.neighbors[0] = at0;
        this.neighbors[1] = at1;
        this.neighbors[2] = at2;
        this.neighbors[3] = at3;
        this.type = type;
        this.parity = parity;
    }

    JniInchiStereo0D(JniInchiAtom atC, JniInchiAtom at0, JniInchiAtom at1, JniInchiAtom at2, JniInchiAtom at3, int type, int parity) {
        this(atC, at0, at1, at2, at3, INCHI_STEREOTYPE.getValue(type), INCHI_PARITY.getValue(parity));
    }

    public void setDisconnectedParity(INCHI_PARITY parity) {
        this.disconParity = parity;
    }

    public JniInchiAtom getCentralAtom() {
        return this.centralAtom;
    }

    public JniInchiAtom[] getNeighbors() {
        return this.neighbors;
    }

    public JniInchiAtom getNeighbor(int i) {
        return this.neighbors[i];
    }

    public INCHI_PARITY getParity() {
        return this.parity;
    }

    public INCHI_PARITY getDisconnectedParity() {
        return this.disconParity;
    }

    public INCHI_STEREOTYPE getStereoType() {
        return this.type;
    }

    public String getDebugString() {
        return "InChI Stereo0D: " + (this.centralAtom == null ? "-" : this.centralAtom.getElementType()) + " [" + this.neighbors[0].getElementType() + "," + this.neighbors[1].getElementType() + "," + this.neighbors[2].getElementType() + "," + this.neighbors[3].getElementType() + "] " + "Type::" + this.type + " // " + "Parity:" + this.parity;
    }

    public void debug() {
        System.out.println(this.getDebugString());
    }

    public static JniInchiStereo0D createNewTetrahedralStereo0D(JniInchiAtom atC, JniInchiAtom at0, JniInchiAtom at1, JniInchiAtom at2, JniInchiAtom at3, INCHI_PARITY parity) {
        JniInchiStereo0D stereo = new JniInchiStereo0D(atC, at0, at1, at2, at3, INCHI_STEREOTYPE.TETRAHEDRAL, parity);
        return stereo;
    }

    public static JniInchiStereo0D createNewDoublebondStereo0D(JniInchiAtom at0, JniInchiAtom at1, JniInchiAtom at2, JniInchiAtom at3, INCHI_PARITY parity) {
        JniInchiStereo0D stereo = new JniInchiStereo0D(null, at0, at1, at2, at3, INCHI_STEREOTYPE.DOUBLEBOND, parity);
        return stereo;
    }

    int getInchiStereoType() {
        return this.type.getIndx();
    }

    int getInchiParity() {
        return this.parity.getIndx();
    }
}

