/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.text.ParseException;
import nu.xom.Attribute;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.cml.base.CMLUtil;

public class DoubleSTAttribute
extends CMLAttribute {
    private static final String S_PLUS = "+";
    public static final String JAVA_TYPE = "double";
    public static final String JAVA_GET_METHOD = "getDouble";
    public static final String JAVA_SHORT_CLASS = "DoubleSTAttribute";
    protected Double d;

    public DoubleSTAttribute(String name) {
        super(name);
    }

    public DoubleSTAttribute(Attribute att) {
        this(att.getLocalName());
        String v = att.getValue();
        if (v != null && !v.trim().equals("")) {
            this.setCMLValue(v);
        }
    }

    public DoubleSTAttribute(Attribute att, String value) {
        super(att, value.trim());
    }

    public DoubleSTAttribute(DoubleSTAttribute att) {
        super(att);
        if (att.d != null) {
            this.d = new Double(att.d);
        }
    }

    public Node copy() {
        return new DoubleSTAttribute(this);
    }

    public String getJavaType() {
        return JAVA_TYPE;
    }

    public void setCMLValue(String s) {
        if (s != null && !s.trim().equals("")) {
            double d;
            try {
                String ss = s.trim();
                if (ss.startsWith(S_PLUS)) {
                    ss = ss.substring(1);
                }
                d = CMLUtil.parseFlexibleDouble(ss);
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("" + nfe, nfe);
            }
            catch (ParseException e) {
                throw new RuntimeException("Bad double: " + s.trim(), e);
            }
            this.setCMLValue(d);
        }
    }

    public void checkValue(double d) throws RuntimeException {
        if (this.cmlType != null) {
            this.cmlType.checkValue(d);
        }
    }

    public void setCMLValue(double d) {
        this.checkValue(d);
        this.d = new Double(d);
        this.setValue("" + d);
    }

    public double getDouble() {
        return this.d;
    }

    public String getJavaGetMethod() {
        return JAVA_GET_METHOD;
    }

    public String getJavaShortClassName() {
        return JAVA_SHORT_CLASS;
    }
}

