/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

public abstract class Parser
implements CommandLineParser {
    private CommandLine cmd;
    private Options options;
    private List requiredOptions;

    protected abstract String[] flatten(Options var1, String[] var2, boolean var3);

    public CommandLine parse(Options options, String[] arguments) throws ParseException {
        return this.parse(options, arguments, false);
    }

    public CommandLine parse(Options opts, String[] arguments, boolean stopAtNonOption) throws ParseException {
        this.options = opts;
        this.requiredOptions = this.options.getRequiredOptions();
        this.cmd = new CommandLine();
        boolean eatTheRest = false;
        List<String> tokenList = Arrays.asList(this.flatten(opts, arguments, stopAtNonOption));
        ListIterator<String> iterator = tokenList.listIterator();
        while (iterator.hasNext()) {
            String t = iterator.next();
            if ("--".equals(t)) {
                eatTheRest = true;
            } else if ("-".equals(t)) {
                if (stopAtNonOption) {
                    eatTheRest = true;
                } else {
                    this.cmd.addArg(t);
                }
            } else if (t.startsWith("-")) {
                if (stopAtNonOption && !this.options.hasOption(t)) {
                    eatTheRest = true;
                    this.cmd.addArg(t);
                } else {
                    this.processOption(t, iterator);
                }
            } else {
                this.cmd.addArg(t);
                if (stopAtNonOption) {
                    eatTheRest = true;
                }
            }
            if (!eatTheRest) continue;
            while (iterator.hasNext()) {
                String str = iterator.next();
                if ("--".equals(str)) continue;
                this.cmd.addArg(str);
            }
        }
        this.checkRequiredOptions();
        return this.cmd;
    }

    private void checkRequiredOptions() throws MissingOptionException {
        if (this.requiredOptions.size() > 0) {
            Iterator iter = this.requiredOptions.iterator();
            StringBuffer buff = new StringBuffer();
            while (iter.hasNext()) {
                buff.append(iter.next());
            }
            throw new MissingOptionException(buff.toString());
        }
    }

    public void processArgs(Option opt, ListIterator iter) throws ParseException {
        while (iter.hasNext()) {
            String var = (String)iter.next();
            if (this.options.hasOption(var)) {
                iter.previous();
                break;
            }
            if (opt.addValue(var)) continue;
            iter.previous();
            break;
        }
        if (opt.getValues() == null && !opt.hasOptionalArg()) {
            throw new MissingArgumentException("no argument for:" + opt.getOpt());
        }
    }

    private void processOption(String arg, ListIterator iter) throws ParseException {
        Option opt = null;
        boolean hasOption = this.options.hasOption(arg);
        if (!hasOption) {
            throw new UnrecognizedOptionException("Unrecognized option: " + arg);
        }
        opt = this.options.getOption(arg);
        if (opt.isRequired()) {
            this.requiredOptions.remove("-" + opt.getOpt());
        }
        if (this.options.getOptionGroup(opt) != null) {
            OptionGroup group = this.options.getOptionGroup(opt);
            if (group.isRequired()) {
                this.requiredOptions.remove(group);
            }
            group.setSelected(opt);
        }
        if (opt.hasArg()) {
            this.processArgs(opt, iter);
        }
        this.cmd.addOption(opt);
    }
}

