/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.group.Permutation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.group.PermutationGroup")
public class PermutationGroup {
    private Permutation[][] permutations;
    private final int size;
    private Permutation base;

    @TestMethod(value="sizeConstructor")
    public PermutationGroup(int size) {
        this(new Permutation(size));
    }

    @TestMethod(value="baseConstructor")
    public PermutationGroup(Permutation base) {
        this.size = base.size();
        this.base = new Permutation(base);
        this.permutations = new Permutation[this.size][this.size];
        for (int i = 0; i < this.size; ++i) {
            this.permutations[i][this.base.get((int)i)] = new Permutation(this.size);
        }
    }

    @TestMethod(value="generatorConstructor")
    public PermutationGroup(int size, List<Permutation> generators) {
        this(new Permutation(size));
        for (Permutation generator : generators) {
            this.enter(generator);
        }
    }

    @TestMethod(value="makeSymNTest")
    public static PermutationGroup makeSymN(int size) {
        ArrayList<Permutation> generators = new ArrayList<Permutation>();
        int[] p1 = new int[size];
        p1[0] = 1;
        p1[1] = 0;
        for (int i = 2; i < size; ++i) {
            p1[i] = i;
        }
        int[] p2 = new int[size];
        p2[0] = 1;
        for (int i = 1; i < size - 1; ++i) {
            p2[i] = i + 1;
        }
        p2[size - 1] = 0;
        generators.add(new Permutation(p1));
        generators.add(new Permutation(p2));
        return new PermutationGroup(size, generators);
    }

    @TestMethod(value="getSizeTest")
    public int getSize() {
        return this.size;
    }

    @TestMethod(value="orderTest")
    public long order() {
        long total = 1L;
        for (int i = 0; i < this.size; ++i) {
            int sum = 0;
            for (int j = 0; j < this.size; ++j) {
                if (this.permutations[i][j] == null) continue;
                ++sum;
            }
            total *= (long)sum;
        }
        return total;
    }

    @TestMethod(value="getTest")
    public Permutation get(int uIndex, int uSubIndex) {
        return this.permutations[uIndex][uSubIndex];
    }

    @TestMethod(value="getLeftTransversalTest")
    public List<Permutation> getLeftTransversal(int index) {
        ArrayList<Permutation> traversal = new ArrayList<Permutation>();
        for (int subIndex = 0; subIndex < this.size; ++subIndex) {
            if (this.permutations[index][subIndex] == null) continue;
            traversal.add(this.permutations[index][subIndex]);
        }
        return traversal;
    }

    @TestMethod(value="transversalTest")
    public List<Permutation> transversal(final PermutationGroup subgroup) {
        final long m = this.order() / subgroup.order();
        final ArrayList<Permutation> results = new ArrayList<Permutation>();
        Backtracker transversalBacktracker = new Backtracker(){
            private boolean finished = false;

            public void applyTo(Permutation p) {
                for (Permutation f : results) {
                    Permutation h = f.invert().multiply(p);
                    if (subgroup.test(h) != PermutationGroup.this.size) continue;
                    return;
                }
                results.add(p);
                if ((long)results.size() >= m) {
                    this.finished = true;
                }
            }

            public boolean isFinished() {
                return this.finished;
            }
        };
        this.apply(transversalBacktracker);
        return results;
    }

    @TestMethod(value="applyTest,apply_FinishEarlyTest")
    public void apply(Backtracker backtracker) {
        this.backtrack(0, new Permutation(this.size), backtracker);
    }

    private void backtrack(int l, Permutation g, Backtracker backtracker) {
        if (backtracker.isFinished()) {
            return;
        }
        if (l == this.size) {
            backtracker.applyTo(g);
        } else {
            for (int i = 0; i < this.size; ++i) {
                Permutation h = this.permutations[l][i];
                if (h == null) continue;
                this.backtrack(l + 1, g.multiply(h), backtracker);
            }
        }
    }

    @TestMethod(value="allTest")
    public List<Permutation> all() {
        final ArrayList<Permutation> permutations = new ArrayList<Permutation>();
        Backtracker counter = new Backtracker(){

            public void applyTo(Permutation p) {
                permutations.add(p);
            }

            public boolean isFinished() {
                return false;
            }
        };
        this.apply(counter);
        return permutations;
    }

    @TestMethod(value="changeBaseTest")
    public void changeBase(Permutation newBase) {
        Permutation g;
        int a;
        int firstDiffIndex;
        int j;
        PermutationGroup h = new PermutationGroup(newBase);
        for (j = firstDiffIndex = this.base.firstIndexOfDifference(newBase); j < this.size; ++j) {
            for (a = 0; a < this.size; ++a) {
                g = this.permutations[j][a];
                if (g == null) continue;
                h.enter(g);
            }
        }
        for (j = 0; j < firstDiffIndex; ++j) {
            for (a = 0; a < this.size; ++a) {
                g = this.permutations[j][a];
                if (g == null) continue;
                int hj = h.base.get(j);
                int x = g.get(hj);
                h.permutations[j][x] = new Permutation(g);
            }
        }
        this.base = new Permutation(h.base);
        this.permutations = (Permutation[][])h.permutations.clone();
    }

    @TestMethod(value="enterTest")
    public void enter(Permutation g) {
        int deg = this.size;
        int i = this.test(g);
        if (i == deg) {
            return;
        }
        this.permutations[i][g.get((int)this.base.get((int)i))] = new Permutation(g);
        for (int j = 0; j <= i; ++j) {
            for (int a = 0; a < deg; ++a) {
                Permutation h = this.permutations[j][a];
                if (h == null) continue;
                Permutation f = g.multiply(h);
                this.enter(f);
            }
        }
    }

    @TestMethod(value="test_SuccessTest,test_FailureTest")
    public int test(Permutation permutation) {
        for (int i = 0; i < this.size; ++i) {
            int x = permutation.get(this.base.get(i));
            Permutation h = this.permutations[i][x];
            if (h == null) {
                return i;
            }
            permutation.setTo(h.invert().multiply(permutation));
        }
        return this.size;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Base = ").append(this.base).append("\n");
        for (int i = 0; i < this.size; ++i) {
            sb.append("U").append(i).append(" = ");
            for (int j = 0; j < this.size; ++j) {
                sb.append(this.permutations[i][j]).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static interface Backtracker {
        public void applyTo(Permutation var1);

        public boolean isFinished();
    }
}

