/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.silent.ChemObject;

public class Element
extends ChemObject
implements Serializable,
IElement,
Cloneable {
    private static final long serialVersionUID = 3062529834691231436L;
    protected String symbol;
    protected Integer atomicNumber = (Integer)CDKConstants.UNSET;

    public Element() {
        this.symbol = null;
    }

    public Element(IElement element) {
        super(element);
        this.symbol = element.getSymbol();
        this.atomicNumber = element.getAtomicNumber();
    }

    public Element(String symbol) {
        this();
        this.symbol = symbol;
    }

    public Element(String symbol, Integer atomicNumber) {
        this(symbol);
        this.atomicNumber = atomicNumber;
    }

    public Integer getAtomicNumber() {
        return this.atomicNumber;
    }

    public void setAtomicNumber(Integer atomicNumber) {
        this.atomicNumber = atomicNumber;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String toString() {
        StringBuffer resultString = new StringBuffer(32);
        resultString.append("Element(").append(this.hashCode());
        if (this.getSymbol() != null) {
            resultString.append(", S:").append(this.getSymbol());
        }
        if (this.getID() != null) {
            resultString.append(", ID:").append(this.getID());
        }
        if (this.getAtomicNumber() != null) {
            resultString.append(", AN:").append(this.getAtomicNumber());
        }
        resultString.append(')');
        return resultString.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean compare(Object object) {
        if (!(object instanceof Element)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        Element elem = (Element)object;
        return this.atomicNumber == elem.atomicNumber && this.symbol.equals(elem.symbol);
    }
}

