/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.ITetrahedralChirality;

public class TetrahedralChirality
implements ITetrahedralChirality {
    private IAtom chiralAtom;
    private IAtom[] ligandAtoms;
    private ITetrahedralChirality.Stereo stereo;
    private IChemObjectBuilder builder;

    public TetrahedralChirality(IAtom chiralAtom, IAtom[] ligandAtoms, ITetrahedralChirality.Stereo chirality) {
        this.chiralAtom = chiralAtom;
        this.ligandAtoms = ligandAtoms;
        this.stereo = chirality;
    }

    @Override
    public IAtom[] getLigands() {
        IAtom[] arrayCopy = new IAtom[4];
        System.arraycopy(this.ligandAtoms, 0, arrayCopy, 0, 4);
        return arrayCopy;
    }

    @Override
    public IAtom getChiralAtom() {
        return this.chiralAtom;
    }

    @Override
    public ITetrahedralChirality.Stereo getStereo() {
        return this.stereo;
    }

    @Override
    public void setStereo(ITetrahedralChirality.Stereo stereo) {
        this.stereo = stereo;
    }

    public void setBuilder(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public boolean contains(IAtom atom) {
        if (this.chiralAtom.equals(atom)) {
            return true;
        }
        for (IAtom ligand : this.ligandAtoms) {
            if (!ligand.equals(atom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ITetrahedralChirality map(Map<IAtom, IAtom> atoms, Map<IBond, IBond> bonds) {
        if (atoms == null) {
            throw new IllegalArgumentException("null atom mapping provided");
        }
        IAtom chiral = this.chiralAtom != null ? atoms.get(this.chiralAtom) : null;
        IAtom[] ligands = new IAtom[this.ligandAtoms.length];
        for (int i = 0; i < ligands.length; ++i) {
            if (this.ligandAtoms[i] == null) continue;
            ligands[i] = atoms.get(this.ligandAtoms[i]);
        }
        return new TetrahedralChirality(chiral, ligands, this.stereo);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Tetrahedral{").append(this.hashCode()).append(", ");
        builder.append((Object)this.getStereo()).append(", ");
        builder.append("c:").append(this.getChiralAtom()).append(", ");
        IAtom[] ligands = this.getLigands();
        for (int i = 0; i < ligands.length; ++i) {
            builder.append(i + 1).append(':').append(ligands[i]).append(", ");
        }
        builder.append('}');
        return builder.toString();
    }
}

