/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.Arrays;
import java.util.List;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;

abstract class Topology {
    private static Topology UNKNOWN = new Topology(){

        @Override
        int atom() {
            throw new IllegalArgumentException("unknown topology");
        }

        @Override
        Configuration configuration() {
            return Configuration.UNKNOWN;
        }

        @Override
        Topology orderBy(int[] rank) {
            return this;
        }

        @Override
        Topology transform(int[] mapping) {
            return this;
        }

        @Override
        void copy(int[] dest) {
        }
    };

    Topology() {
    }

    abstract int atom();

    abstract Configuration configuration();

    Configuration configurationOf(int[] rank) {
        return this.orderBy(rank).configuration();
    }

    Configuration.Type type() {
        return this.configuration().type();
    }

    abstract Topology orderBy(int[] var1);

    abstract Topology transform(int[] var1);

    abstract void copy(int[] var1);

    static int parity(int[] vs, int[] rank) {
        int count = 0;
        for (int i = 0; i < vs.length; ++i) {
            for (int j = i + 1; j < vs.length; ++j) {
                if (rank[vs[i]] <= rank[vs[j]]) continue;
                ++count;
            }
        }
        return count & true ? -1 : 1;
    }

    static int parity4(int[] vs, int[] rank) {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            int prev = rank[vs[i]];
            for (int j = i + 1; j < 4; ++j) {
                if (prev <= rank[vs[j]]) continue;
                ++count;
            }
        }
        return count & true ? -1 : 1;
    }

    static int[] sort(int[] vs, int[] rank) {
        int i;
        int[] ws = Arrays.copyOf(vs, vs.length);
        int j = i = 0;
        while (i < vs.length - 1) {
            int v = ws[i + 1];
            while (rank[v] < rank[ws[j]]) {
                ws[j + 1] = ws[j];
                if (--j >= 0) continue;
            }
            ws[j + 1] = v;
            j = ++i;
        }
        return ws;
    }

    static Topology unknown() {
        return UNKNOWN;
    }

    static Topology tetrahedral(int u, int[] vs, Configuration configuration) {
        if (configuration.type() != Configuration.Type.Implicit && configuration.type() != Configuration.Type.Tetrahedral) {
            throw new IllegalArgumentException((Object)((Object)configuration.type()) + "invalid tetrahedral configuration");
        }
        int p = configuration.shorthand() == Configuration.CLOCKWISE ? 1 : -1;
        return new Tetrahedral(u, Arrays.copyOf(vs, vs.length), p);
    }

    static Topology extendedTetrahedral(int u, int[] vs, Configuration configuration) {
        if (configuration.type() != Configuration.Type.Implicit && configuration.type() != Configuration.Type.ExtendedTetrahedral) {
            throw new IllegalArgumentException((Object)((Object)configuration.type()) + "invalid extended tetrahedral configuration");
        }
        int p = configuration.shorthand() == Configuration.CLOCKWISE ? 1 : -1;
        return new ExtendedTetrahedral(u, Arrays.copyOf(vs, vs.length), p);
    }

    static Topology trigonal(int u, int[] vs, Configuration configuration) {
        if (configuration.type() != Configuration.Type.Implicit && configuration.type() != Configuration.Type.DoubleBond) {
            throw new IllegalArgumentException((Object)((Object)configuration.type()) + "invalid tetrahedral configuration");
        }
        int p = configuration.shorthand() == Configuration.CLOCKWISE ? 1 : -1;
        return new Trigonal(u, Arrays.copyOf(vs, vs.length), p);
    }

    static Configuration toExplicit(Graph g, int u, Configuration c) {
        if (c.type() != Configuration.Type.Implicit) {
            return c;
        }
        int deg = g.degree(u);
        int valence = deg + g.atom(u).hydrogens();
        if (valence == 4) {
            return c == Configuration.ANTI_CLOCKWISE ? Configuration.TH1 : Configuration.TH2;
        }
        if (valence == 3) {
            if (g.atom(u).element() == Element.Sulfur || g.atom(u).element() == Element.Selenium) {
                int sb = 0;
                int db = 0;
                int d = g.degree(u);
                for (int j = 0; j < d; ++j) {
                    Edge e = g.edgeAt(u, j);
                    if (e.bond().order() == 1) {
                        ++sb;
                        continue;
                    }
                    if (e.bond().order() == 2) {
                        ++db;
                        continue;
                    }
                    return Configuration.UNKNOWN;
                }
                int q = g.atom(u).charge();
                if (q == 0 && sb == 2 && db == 1 || q == 1 && sb == 3) {
                    return c == Configuration.ANTI_CLOCKWISE ? Configuration.TH1 : Configuration.TH2;
                }
                return Configuration.UNKNOWN;
            }
            if (g.atom(u).element() == Element.Phosphorus && g.bondedValence(u) == 3 && g.implHCount(u) == 0 && g.atom(u).charge() == 0) {
                return c == Configuration.ANTI_CLOCKWISE ? Configuration.TH1 : Configuration.TH2;
            }
            int nDoubleBonds = 0;
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge e = g.edgeAt(u, j);
                if (e.bond() != Bond.DOUBLE) continue;
                ++nDoubleBonds;
            }
            if (nDoubleBonds == 1) {
                return c == Configuration.ANTI_CLOCKWISE ? Configuration.DB1 : Configuration.DB2;
            }
            return Configuration.UNKNOWN;
        }
        if (deg == 2) {
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge e = g.edgeAt(u, j);
                if (e.bond() == Bond.DOUBLE) continue;
                return Configuration.UNKNOWN;
            }
            return c == Configuration.ANTI_CLOCKWISE ? Configuration.AL1 : Configuration.AL2;
        }
        if (valence == 5) {
            return c == Configuration.ANTI_CLOCKWISE ? Configuration.TB1 : Configuration.TB2;
        }
        if (valence == 6) {
            return c == Configuration.ANTI_CLOCKWISE ? Configuration.OH1 : Configuration.OH2;
        }
        return Configuration.UNKNOWN;
    }

    static Topology create(int u, int[] vs, List<Edge> es, Configuration c) {
        if (c.type() == Configuration.Type.Implicit) {
            throw new IllegalArgumentException("configuration must be explicit, @TH1/@TH2 instead of @/@@");
        }
        if (c.type() == Configuration.Type.Tetrahedral) {
            return Topology.tetrahedral(u, vs, c);
        }
        if (c.type() == Configuration.Type.DoubleBond) {
            return Topology.trigonal(u, vs, c);
        }
        if (c.type() == Configuration.Type.ExtendedTetrahedral) {
            return Topology.extendedTetrahedral(u, vs, c);
        }
        return Topology.unknown();
    }

    private static final class Trigonal
    extends Topology {
        private final int u;
        private final int[] vs;
        private final int p;

        private Trigonal(int u, int[] vs, int p) {
            if (vs.length != 3) {
                throw new IllegalArgumentException("Trigonal topology requires 3 vertices - use the 'centre' vertex to mark implicit verticies");
            }
            this.u = u;
            this.vs = vs;
            this.p = p;
        }

        @Override
        int atom() {
            return this.u;
        }

        @Override
        Configuration configuration() {
            return this.p < 0 ? Configuration.DB1 : Configuration.DB2;
        }

        @Override
        Topology orderBy(int[] rank) {
            return new Trigonal(this.u, Trigonal.sort(this.vs, rank), this.p * Trigonal.parity(this.vs, rank));
        }

        @Override
        Topology transform(int[] mapping) {
            int[] ws = new int[this.vs.length];
            for (int i = 0; i < this.vs.length; ++i) {
                ws[i] = mapping[this.vs[i]];
            }
            return new Trigonal(mapping[this.u], ws, this.p);
        }

        @Override
        void copy(int[] dest) {
            System.arraycopy(this.vs, 0, dest, 0, 3);
        }

        public String toString() {
            return this.u + " " + Arrays.toString(this.vs) + ":" + this.p;
        }
    }

    private static final class ExtendedTetrahedral
    extends Topology {
        private final int u;
        private final int[] vs;
        private final int p;

        private ExtendedTetrahedral(int u, int[] vs, int p) {
            if (vs.length != 4) {
                throw new IllegalArgumentException("Tetrahedral topology requires 4 vertices - use the 'centre' vertex to mark implicit verticies");
            }
            this.u = u;
            this.vs = vs;
            this.p = p;
        }

        @Override
        int atom() {
            return this.u;
        }

        @Override
        Configuration configuration() {
            return this.p < 0 ? Configuration.AL1 : Configuration.AL2;
        }

        @Override
        Topology orderBy(int[] rank) {
            return new ExtendedTetrahedral(this.u, ExtendedTetrahedral.sort(this.vs, rank), this.p * ExtendedTetrahedral.parity4(this.vs, rank));
        }

        @Override
        Topology transform(int[] mapping) {
            int[] ws = new int[this.vs.length];
            for (int i = 0; i < this.vs.length; ++i) {
                ws[i] = mapping[this.vs[i]];
            }
            return new ExtendedTetrahedral(mapping[this.u], ws, this.p);
        }

        @Override
        void copy(int[] dest) {
            System.arraycopy(this.vs, 0, dest, 0, 4);
        }

        public String toString() {
            return this.u + " " + Arrays.toString(this.vs) + ":" + this.p;
        }
    }

    private static final class Tetrahedral
    extends Topology {
        private final int u;
        private final int[] vs;
        private final int p;

        private Tetrahedral(int u, int[] vs, int p) {
            if (vs.length != 4) {
                throw new IllegalArgumentException("Tetrahedral topology requires 4 vertices - use the 'centre' vertex to mark implicit verticies");
            }
            this.u = u;
            this.vs = vs;
            this.p = p;
        }

        @Override
        int atom() {
            return this.u;
        }

        @Override
        Configuration configuration() {
            return this.p < 0 ? Configuration.TH1 : Configuration.TH2;
        }

        @Override
        Topology orderBy(int[] rank) {
            return new Tetrahedral(this.u, Tetrahedral.sort(this.vs, rank), this.p * Tetrahedral.parity4(this.vs, rank));
        }

        @Override
        Topology transform(int[] mapping) {
            int[] ws = new int[this.vs.length];
            for (int i = 0; i < this.vs.length; ++i) {
                ws[i] = mapping[this.vs[i]];
            }
            return new Tetrahedral(mapping[this.u], ws, this.p);
        }

        @Override
        void copy(int[] dest) {
            System.arraycopy(this.vs, 0, dest, 0, 4);
        }

        @Override
        Configuration configurationOf(int[] rank) {
            return this.p * Tetrahedral.parity4(this.vs, rank) < 0 ? Configuration.TH1 : Configuration.TH2;
        }

        public String toString() {
            return this.u + " " + Arrays.toString(this.vs) + ":" + this.p;
        }
    }
}

