/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.regression.Regression;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewRegressionListSubjects
extends ModelTestBase {
    protected Model m;
    static final String subjectPrefix = "http://aldabaran/test8/s";
    static final String predicatePrefix = "http://aldabaran/test8/";
    Resource[] subjects;
    Property[] predicates;
    RDFNode[] objects;
    Literal[] tvLitObjs;
    Resource[] tvResObjs;
    boolean[] tvBooleans = new boolean[]{false, true};
    long[] tvLongs = new long[]{123L, 321L};
    char[] tvChars = new char[]{'@', ';'};
    float[] tvFloats = new float[]{456.789f, 789.456f};
    double[] tvDoubles = new double[]{123.456, 456.123};
    String[] tvStrings = new String[]{"test8 testing string 1", "test8 testing string 2"};
    String[] langs = new String[]{"en", "fr"};

    public NewRegressionListSubjects(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NewRegressionListSubjects.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
        this.fillModel();
    }

    public void tearDown() {
        this.m = null;
    }

    protected Set<Resource> subjectsTo(String prefix, int limit) {
        HashSet<Resource> result = new HashSet<Resource>();
        for (int i = 0; i < limit; ++i) {
            result.add(NewRegressionListSubjects.resource((String)(prefix + i)));
        }
        return result;
    }

    public void test8() {
        this.assertEquiv(this.subjectsTo(subjectPrefix, 5), this.m.listResourcesWithProperty(this.predicates[4]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 2), this.m.listResourcesWithProperty(this.predicates[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 2), this.m.listResourcesWithProperty(this.predicates[0], this.tvBooleans[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listResourcesWithProperty(this.predicates[0], this.tvBooleans[1]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 2), this.m.listResourcesWithProperty(this.predicates[0], this.tvChars[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listResourcesWithProperty(this.predicates[0], this.tvChars[1]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 2), this.m.listResourcesWithProperty(this.predicates[0], this.tvLongs[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listResourcesWithProperty(this.predicates[0], this.tvLongs[1]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 2), this.m.listResourcesWithProperty(this.predicates[0], this.tvFloats[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listResourcesWithProperty(this.predicates[0], this.tvFloats[1]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 2), this.m.listResourcesWithProperty(this.predicates[0], this.tvDoubles[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listResourcesWithProperty(this.predicates[0], this.tvDoubles[1]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 2), this.m.listResourcesWithProperty(this.predicates[0], (byte)this.tvLongs[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listResourcesWithProperty(this.predicates[0], (byte)this.tvLongs[1]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 2), this.m.listResourcesWithProperty(this.predicates[0], (short)this.tvLongs[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listResourcesWithProperty(this.predicates[0], (short)this.tvLongs[1]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 2), this.m.listResourcesWithProperty(this.predicates[0], (int)this.tvLongs[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listResourcesWithProperty(this.predicates[0], (int)this.tvLongs[1]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 2), this.m.listSubjectsWithProperty(this.predicates[0], this.tvStrings[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listSubjectsWithProperty(this.predicates[0], this.tvStrings[1]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 2), this.m.listSubjectsWithProperty(this.predicates[0], this.tvStrings[0], this.langs[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listSubjectsWithProperty(this.predicates[0], this.tvStrings[1], this.langs[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listSubjectsWithProperty(this.predicates[0], this.tvStrings[0], this.langs[1]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listSubjectsWithProperty(this.predicates[0], this.tvStrings[1], this.langs[1]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 2), this.m.listResourcesWithProperty(this.predicates[0], this.tvLitObjs[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listResourcesWithProperty(this.predicates[0], this.tvLitObjs[1]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 2), this.m.listResourcesWithProperty(this.predicates[0], this.tvResObjs[0]));
        this.assertEquiv(this.subjectsTo(subjectPrefix, 0), this.m.listResourcesWithProperty(this.predicates[0], this.tvResObjs[1]));
    }

    protected void assertEquiv(Set<? extends Resource> set, Iterator<? extends Resource> iterator) {
        List L = NewRegressionListSubjects.iteratorToList(iterator);
        NewRegressionListSubjects.assertEquals((int)set.size(), (int)L.size());
        NewRegressionListSubjects.assertEquals(set, new HashSet(L));
    }

    public void testGetRequiredProperty() {
        Statement s = this.m.getRequiredProperty(this.subjects[1], this.predicates[1]);
        try {
            this.m.getRequiredProperty(this.subjects[1], RDF.value);
            NewRegressionListSubjects.fail((String)"should not find absent property");
        }
        catch (PropertyNotFoundException e) {
            NewRegressionListSubjects.pass();
        }
    }

    protected void fillModel() {
        int i;
        int num = 5;
        this.tvLitObjs = new Literal[]{this.m.createTypedLiteral(new Regression.LitTestObjF()), this.m.createTypedLiteral(new Regression.LitTestObjF())};
        this.tvResObjs = new Resource[]{this.m.createResource(new Regression.ResTestObjF()), this.m.createResource(new Regression.ResTestObjF())};
        this.objects = new RDFNode[]{this.m.createTypedLiteral(this.tvBooleans[1]), this.m.createTypedLiteral(this.tvLongs[1]), this.m.createTypedLiteral(this.tvChars[1]), this.m.createTypedLiteral(this.tvFloats[1]), this.m.createTypedLiteral(this.tvDoubles[1]), this.m.createLiteral(this.tvStrings[1]), this.m.createLiteral(this.tvStrings[1], this.langs[1]), this.tvLitObjs[1], this.tvResObjs[1]};
        this.subjects = new Resource[5];
        this.predicates = new Property[5];
        for (i = 0; i < 5; ++i) {
            this.subjects[i] = this.m.createResource(subjectPrefix + i);
            this.predicates[i] = this.m.createProperty(predicatePrefix + i, "p");
        }
        for (i = 0; i < 5; ++i) {
            this.m.addLiteral(this.subjects[i], this.predicates[4], false);
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.m.add(this.subjects[i], this.predicates[j], this.m.createTypedLiteral(this.tvBooleans[j]));
                this.m.addLiteral(this.subjects[i], this.predicates[j], this.tvLongs[j]);
                this.m.addLiteral(this.subjects[i], this.predicates[j], this.tvChars[j]);
                this.m.add(this.subjects[i], this.predicates[j], this.m.createTypedLiteral(this.tvFloats[j]));
                this.m.add(this.subjects[i], this.predicates[j], this.m.createTypedLiteral(this.tvDoubles[j]));
                this.m.add(this.subjects[i], this.predicates[j], this.tvStrings[j]);
                this.m.add(this.subjects[i], this.predicates[j], this.tvStrings[j], this.langs[j]);
                this.m.add(this.subjects[i], this.predicates[j], this.tvLitObjs[j]);
                this.m.add(this.subjects[i], this.predicates[j], this.tvResObjs[j]);
            }
        }
    }
}

