/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.impl.ConsumerChoicePointFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;

public class LPTopGoalIterator
implements ClosableIterator<Triple>,
LPInterpreterContext {
    Triple lookAhead;
    LPInterpreter interpreter;
    BackwardRuleInfGraphI infgraph;
    protected Set<ConsumerChoicePointFrame> choicePoints = new HashSet<ConsumerChoicePointFrame>();
    protected ConsumerChoicePointFrame nextToRun;
    protected boolean isReady = true;
    protected boolean checkReadyNeeded = false;
    boolean lookaheadValid = false;
    protected int initialVersion;

    public LPTopGoalIterator(LPInterpreter engine) {
        this.interpreter = engine;
        this.infgraph = engine.getEngine().getInfGraph();
        this.initialVersion = this.infgraph.getVersion();
        engine.setTopInterpreter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void moveForward() {
        LPBRuleEngine lpEngine;
        this.checkClosed();
        LPBRuleEngine lPBRuleEngine = lpEngine = this.interpreter.getEngine();
        synchronized (lPBRuleEngine) {
            this.lookaheadValid = true;
            Object next = this.interpreter.next();
            Triple triple = this.lookAhead = next instanceof Triple ? (Triple)next : null;
            if (next == StateFlag.FAIL) {
                if (this.choicePoints.isEmpty()) {
                    this.close();
                } else {
                    this.nextToRun = null;
                    lpEngine.pump(this);
                    if (this.nextToRun == null) {
                        this.close();
                    } else {
                        this.interpreter.setState(this.nextToRun);
                        this.moveForward();
                    }
                }
            }
        }
    }

    @Override
    public void notifyBlockedOn(ConsumerChoicePointFrame ccp) {
        this.choicePoints.add(ccp);
        this.checkReadyNeeded = true;
    }

    @Override
    public void notifyFinished(ConsumerChoicePointFrame ccp) {
        this.choicePoints.remove(ccp);
        this.checkReadyNeeded = true;
    }

    @Override
    public void setReady(ConsumerChoicePointFrame ccp) {
        this.nextToRun = ccp;
        this.isReady = true;
        this.checkReadyNeeded = false;
    }

    @Override
    public boolean isReady() {
        if (this.checkReadyNeeded) {
            this.isReady = false;
            for (ConsumerChoicePointFrame ccp : this.choicePoints) {
                if (!ccp.isReady()) continue;
                if (this.nextToRun == null) {
                    this.nextToRun = ccp;
                }
                this.isReady = true;
                break;
            }
            this.checkReadyNeeded = false;
            return this.isReady;
        }
        return this.isReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.interpreter != null) {
            LPBRuleEngine lPBRuleEngine = this.interpreter.getEngine();
            synchronized (lPBRuleEngine) {
                this.interpreter.getEngine().checkForCompletions();
                this.lookAhead = null;
                this.interpreter.close();
                this.interpreter = null;
                this.isReady = false;
                this.checkReadyNeeded = false;
                this.nextToRun = null;
            }
        }
    }

    @Override
    public boolean hasNext() {
        this.checkCME();
        if (!this.lookaheadValid) {
            this.moveForward();
        }
        return this.lookAhead != null;
    }

    @Override
    public Triple next() {
        this.checkCME();
        if (!this.lookaheadValid) {
            this.moveForward();
        }
        if (this.lookAhead == null) {
            throw new NoSuchElementException("Overran end of LP result set");
        }
        Triple result = this.lookAhead;
        this.lookaheadValid = false;
        return result;
    }

    private void checkCME() {
        if (this.initialVersion != this.infgraph.getVersion()) {
            throw new ConcurrentModificationException();
        }
    }

    private void checkClosed() {
        if (this.interpreter == null || this.interpreter.getEngine() == null) {
            throw new ConcurrentModificationException("Due to closed iterator");
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

