/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.InitialCycles;

@TestClass(value="org.openscience.cdk.graph.EdgeShortCyclesTest")
final class EdgeShortCycles {
    private final List<int[]> paths;

    EdgeShortCycles(int[][] graph) {
        this(new InitialCycles(graph));
    }

    EdgeShortCycles(InitialCycles initialCycles) {
        int[][] graph = initialCycles.graph();
        int[] sizeOf = new int[initialCycles.numberOfEdges()];
        this.paths = new ArrayList<int[]>(initialCycles.numberOfCycles());
        for (InitialCycles.Cycle cycle : initialCycles.cycles()) {
            int length = cycle.length();
            int[] path = cycle.path();
            boolean found = false;
            for (int i = 1; i < path.length; ++i) {
                int idx = initialCycles.indexOfEdge(path[i - 1], path[i]);
                if (sizeOf[idx] >= 1 && length > sizeOf[idx]) continue;
                found = true;
                sizeOf[idx] = length;
            }
            if (!found) continue;
            for (int[] p : cycle.family()) {
                this.paths.add(p);
            }
        }
    }

    @TestMethod(value="paths_bicyclo,paths_napthalene,paths_anthracene,paths_cyclophane_even")
    int[][] paths() {
        int[][] paths = new int[this.paths.size()][0];
        for (int i = 0; i < this.paths.size(); ++i) {
            paths[i] = this.paths.get(i);
        }
        return paths;
    }

    @TestMethod(value="size_bicyclo,size_napthalene,size_anthracene,size_cyclophane_even")
    int size() {
        return this.paths.size();
    }
}

