/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import java.util.BitSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.hash.Suppressed;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;

@TestClass(value="org.openscience.cdk.hash.AtomSuppressionTest")
abstract class AtomSuppression {
    private static final AtomSuppression unsuppressed = new Unsuppressed();
    private static final AtomSuppression anyHydrogens = new AnyHydrogens();
    private static final AtomSuppression anyPseudos = new AnyPseudos();

    AtomSuppression() {
    }

    abstract Suppressed suppress(IAtomContainer var1);

    @TestMethod(value="unsuppressed")
    static AtomSuppression unsuppressed() {
        return unsuppressed;
    }

    @TestMethod(value="anyHydrogens")
    static AtomSuppression anyHydrogens() {
        return anyHydrogens;
    }

    @TestMethod(value="anyPseudos")
    static AtomSuppression anyPseudos() {
        return anyPseudos;
    }

    private static final class AnyPseudos
    extends AtomSuppression {
        private AnyPseudos() {
        }

        @Override
        Suppressed suppress(IAtomContainer container) {
            BitSet hydrogens = new BitSet();
            for (int i = 0; i < container.getAtomCount(); ++i) {
                IAtom atom = container.getAtom(i);
                hydrogens.set(i, atom instanceof IPseudoAtom);
            }
            return Suppressed.fromBitSet(hydrogens);
        }
    }

    private static final class AnyHydrogens
    extends AtomSuppression {
        private AnyHydrogens() {
        }

        @Override
        Suppressed suppress(IAtomContainer container) {
            BitSet hydrogens = new BitSet();
            for (int i = 0; i < container.getAtomCount(); ++i) {
                IAtom atom = container.getAtom(i);
                hydrogens.set(i, "H".equals(atom.getSymbol()));
            }
            return Suppressed.fromBitSet(hydrogens);
        }
    }

    private static final class Unsuppressed
    extends AtomSuppression {
        private Unsuppressed() {
        }

        @Override
        Suppressed suppress(IAtomContainer container) {
            return Suppressed.none();
        }
    }
}

