/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.hash.AbstractHashGenerator;
import org.openscience.cdk.hash.AtomEncoder;
import org.openscience.cdk.hash.AtomHashGenerator;
import org.openscience.cdk.hash.AtomSuppression;
import org.openscience.cdk.hash.Pseudorandom;
import org.openscience.cdk.hash.Suppressed;
import org.openscience.cdk.hash.Xorshift;
import org.openscience.cdk.interfaces.IAtomContainer;

@TestClass(value="org.openscience.cdk.hash.SeedGeneratorTest")
final class SeedGenerator
extends AbstractHashGenerator
implements AtomHashGenerator {
    private final AtomEncoder encoder;
    private final AtomSuppression suppression;

    @TestMethod(value="testConstruct_Null")
    public SeedGenerator(AtomEncoder encoder) {
        this(encoder, new Xorshift(), AtomSuppression.unsuppressed());
    }

    public SeedGenerator(AtomEncoder encoder, AtomSuppression suppression) {
        this(encoder, new Xorshift(), suppression);
    }

    SeedGenerator(AtomEncoder encoder, Pseudorandom pseudorandom, AtomSuppression suppression) {
        super(pseudorandom);
        if (encoder == null) {
            throw new NullPointerException("encoder cannot be null");
        }
        if (suppression == null) {
            throw new NullPointerException("suppression cannot be null, use AtomSuppression.unsuppressed()");
        }
        this.encoder = encoder;
        this.suppression = suppression;
    }

    @Override
    @TestMethod(value="testGenerate,testGenerate_SizeSeeding")
    public long[] generate(IAtomContainer container) {
        Suppressed suppressed = this.suppression.suppress(container);
        int n = container.getAtomCount();
        int m = n - suppressed.count();
        int seed = m > 1 ? 9803 % m : 1;
        long[] hashes = new long[n];
        for (int i = 0; i < n; ++i) {
            hashes[i] = this.distribute(seed * this.encoder.encode(container.getAtom(i), container));
        }
        return hashes;
    }
}

