/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;

@TestClass(value="org.openscience.cdk.isomorphism.BondMatcherTest")
public abstract class BondMatcher {
    public abstract boolean matches(IBond var1, IBond var2);

    @TestMethod(value="anyMatch")
    public static BondMatcher forAny() {
        return new AnyMatcher();
    }

    @TestMethod(value="aromaticStrictMatch,aliphaticStrictMatch")
    public static BondMatcher forStrictOrder() {
        return new StrictOrderMatcher();
    }

    @TestMethod(value="aromaticMatch,aliphaticMatch")
    public static BondMatcher forOrder() {
        return new OrderMatcher();
    }

    @TestMethod(value="queryMatch")
    public static BondMatcher forQuery() {
        return new QueryMatcher();
    }

    private static final class QueryMatcher
    extends BondMatcher {
        private QueryMatcher() {
        }

        @Override
        public boolean matches(IBond bond1, IBond bond2) {
            return ((IQueryBond)bond1).matches(bond2);
        }
    }

    private static final class AnyMatcher
    extends BondMatcher {
        private AnyMatcher() {
        }

        @Override
        public boolean matches(IBond bond1, IBond bond2) {
            return true;
        }
    }

    private static final class StrictOrderMatcher
    extends BondMatcher {
        private StrictOrderMatcher() {
        }

        @Override
        public boolean matches(IBond bond1, IBond bond2) {
            return bond1.getFlag(32) == bond2.getFlag(32) && (bond1.getOrder() == bond2.getOrder() || bond1.getFlag(32) && bond2.getFlag(32));
        }
    }

    private static final class OrderMatcher
    extends BondMatcher {
        private OrderMatcher() {
        }

        @Override
        public boolean matches(IBond bond1, IBond bond2) {
            return bond1.getFlag(32) && bond2.getFlag(32) || bond1.getOrder() == bond2.getOrder();
        }
    }
}

