/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.similarity;

import java.util.Map;
import java.util.TreeSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="org.openscience.cdk.similarity.LingoSimilarityTest")
public class LingoSimilarity {
    private LingoSimilarity() {
    }

    @TestMethod(value="testLingoSim")
    public static float calculate(Map<String, Integer> features1, Map<String, Integer> features2) {
        TreeSet<String> keys = new TreeSet<String>(features1.keySet());
        keys.addAll(features2.keySet());
        float sum = 0.0f;
        for (String key : keys) {
            Integer c1 = features1.get(key);
            Integer c2 = features2.get(key);
            c1 = c1 == null ? 0 : c1;
            c2 = c2 == null ? 0 : c2;
            sum = (float)((double)sum + (1.0 - (double)(Math.abs(c1 - c2) / (c1 + c2))));
        }
        return sum / (float)keys.size();
    }
}

