/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="org.openscience.cdk.tools.AtomicPropertiesTest")
public class AtomicProperties {
    private static AtomicProperties ap = null;
    private Map<String, Double> htMass = new Hashtable<String, Double>();
    private Map<String, Double> htVdWVolume = new Hashtable<String, Double>();
    private Map<String, Double> htElectronegativity = new Hashtable<String, Double>();
    private Map<String, Double> htPolarizability = new Hashtable<String, Double>();

    private AtomicProperties() throws IOException {
        String Line4;
        String configFile = "org/openscience/cdk/config/data/whim_weights.txt";
        InputStream ins = this.getClass().getClassLoader().getResourceAsStream(configFile);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ins));
        bufferedReader.readLine();
        while ((Line4 = bufferedReader.readLine()) != null) {
            String[] components = Line4.split("\t");
            String symbol = components[0];
            this.htMass.put(symbol, Double.parseDouble(components[1]));
            this.htVdWVolume.put(symbol, Double.parseDouble(components[2]));
            this.htElectronegativity.put(symbol, Double.parseDouble(components[3]));
            this.htPolarizability.put(symbol, Double.parseDouble(components[4]));
        }
        bufferedReader.close();
    }

    @TestMethod(value="testGetVdWVolume")
    public double getVdWVolume(String symbol) {
        return this.htVdWVolume.get(symbol);
    }

    @TestMethod(value="testGetNormalizedVdWVolume")
    public double getNormalizedVdWVolume(String symbol) {
        return this.getVdWVolume(symbol) / this.getVdWVolume("C");
    }

    @TestMethod(value="testGetElectronegativity")
    public double getElectronegativity(String symbol) {
        return this.htElectronegativity.get(symbol);
    }

    @TestMethod(value="testGetNormalizedElectronegativity")
    public double getNormalizedElectronegativity(String symbol) {
        return this.getElectronegativity(symbol) / this.getElectronegativity("C");
    }

    @TestMethod(value="testGetPolarizability")
    public double getPolarizability(String symbol) {
        return this.htPolarizability.get(symbol);
    }

    @TestMethod(value="testGetNormalizedPolarizability")
    public double getNormalizedPolarizability(String symbol) {
        return this.getPolarizability(symbol) / this.getPolarizability("C");
    }

    @TestMethod(value="testGetMass")
    public double getMass(String symbol) {
        return this.htMass.get(symbol);
    }

    @TestMethod(value="testGetNormalizedMass")
    public double getNormalizedMass(String symbol) {
        return this.getMass(symbol) / this.getMass("C");
    }

    @TestMethod(value="testGetInstance")
    public static AtomicProperties getInstance() throws IOException {
        if (ap == null) {
            ap = new AtomicProperties();
        }
        return ap;
    }
}

