/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.attribute;

import java.util.List;
import nu.xom.Attribute;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.StringSTAttribute;

public class RefAttribute
extends StringSTAttribute {
    public static final String NAME = "ref";

    public RefAttribute() {
        super(NAME);
    }

    public RefAttribute(String value) {
        super(NAME);
        this.setCMLValue(value);
    }

    public RefAttribute(Attribute att) throws RuntimeException {
        super(att);
    }

    public void setCMLValue(String value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null ref attribute value");
        }
        if (!value.trim().equals("")) {
            super.setCMLValue(value);
        }
    }

    public static void process(CMLElement element) {
        RefAttribute ref = (RefAttribute)element.getAttribute(NAME);
        if (ref != null) {
            RefAttribute.process(element, ref);
        }
        List<CMLElement> childElems = element.getChildCMLElements();
        for (CMLElement child : childElems) {
            RefAttribute.process(child);
        }
    }

    public static void process(CMLElement element, RefAttribute ref) throws RuntimeException {
        if (element == null) {
            throw new RuntimeException("Cannot process null ref attribute");
        }
        CMLElement oldest = element.getOldestCMLAncestor();
        if (oldest == element) {
            throw new RuntimeException("Cannot reference elements from oldest ancestor");
        }
        String id = ref.getValue();
        List<CMLElement> elemList = oldest.getElementsById(id, true);
        if (elemList.size() == 0) {
            throw new RuntimeException("Cannot find element: " + id);
        }
        if (elemList.size() > 1) {
            throw new RuntimeException("Too many elements (" + elemList.size() + ") with id: " + id);
        }
        CMLElement elemRef = elemList.get(0);
        CMLElement newElem = (CMLElement)elemRef.copy();
        String idgen = element.getAttributeValue("idgen");
        if (idgen != null) {
            newElem.addAttribute(new Attribute("id", idgen));
        }
        CMLElement parent = (CMLElement)element.getParent();
        int idx = parent.indexOf((Node)element);
        parent.insertChild((Node)newElem, idx);
    }
}

