/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.RGroupQueryFormat;
import org.openscience.cdk.isomorphism.matchers.IRGroupQuery;
import org.openscience.cdk.isomorphism.matchers.RGroup;
import org.openscience.cdk.isomorphism.matchers.RGroupList;

public class RGroupQueryWriter
extends DefaultChemObjectWriter {
    private BufferedWriter writer;
    private static String LSEP = System.getProperty("line.separator");

    public RGroupQueryWriter(Writer out) {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    public RGroupQueryWriter() {
        this(new StringWriter());
    }

    @Override
    @TestMethod(value="testAccepts")
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!IRGroupQuery.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.writer.close();
    }

    private String getCTAB(IAtomContainer atomContainer) throws CDKException {
        StringWriter strWriter = new StringWriter();
        MDLV2000Writer mdlWriter = new MDLV2000Writer(strWriter);
        mdlWriter.write((IChemObject)atomContainer);
        try {
            mdlWriter.close();
        }
        catch (IOException exception) {
            // empty catch block
        }
        String ctab = strWriter.toString();
        for (int line = 1; line <= 3; ++line) {
            ctab = ctab.substring(ctab.indexOf(LSEP) + LSEP.length());
        }
        return ctab;
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return RGroupQueryFormat.getInstance();
    }

    @Override
    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    @Override
    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    @Override
    public void write(IChemObject object) throws CDKException {
        if (!(object instanceof IRGroupQuery)) {
            throw new CDKException("Only IRGroupQuery input is accepted.");
        }
        try {
            IRGroupQuery rGroupQuery = (IRGroupQuery)object;
            String now = new SimpleDateFormat("MMddyyHHmm").format(System.currentTimeMillis());
            IAtomContainer rootAtc = rGroupQuery.getRootStructure();
            StringBuffer rootBlock = new StringBuffer();
            String header = "$MDL  REV  1   " + now + LSEP + "$MOL" + LSEP + "$HDR" + LSEP + "  Rgroup query file (RGFile)" + LSEP + "  CDK    " + now + "2D" + LSEP + LSEP + "$END HDR" + LSEP + "$CTAB";
            rootBlock.append(header).append(LSEP);
            String rootCTAB = this.getCTAB(rootAtc);
            rootCTAB = rootCTAB.replaceAll(LSEP + "M  END" + LSEP, "");
            rootBlock.append(rootCTAB).append(LSEP);
            for (Integer rgrpNum : rGroupQuery.getRGroupDefinitions().keySet()) {
                RGroupList rgList = (RGroupList)rGroupQuery.getRGroupDefinitions().get(rgrpNum);
                int restH = rgList.isRestH() ? 1 : 0;
                String logLine = "M  LOG" + MDLV2000Writer.formatMDLInt(1, 3) + MDLV2000Writer.formatMDLInt(rgrpNum, 4) + MDLV2000Writer.formatMDLInt(rgList.getRequiredRGroupNumber(), 4) + MDLV2000Writer.formatMDLInt(restH, 4) + "   " + rgList.getOccurrence();
                rootBlock.append(logLine).append(LSEP);
            }
            for (IAtom rgroupAtom : rGroupQuery.getRootAttachmentPoints().keySet()) {
                int atIdx;
                Map rApo = (Map)rGroupQuery.getRootAttachmentPoints().get(rgroupAtom);
                if (rApo.size() <= 1) continue;
                int prevPos = -1;
                int apoIdx = 1;
                boolean implicitlyOrdered = true;
                while (rApo.get(apoIdx) != null && implicitlyOrdered) {
                    IAtom partner = ((IBond)rApo.get(apoIdx)).getConnectedAtom(rgroupAtom);
                    for (atIdx = 0; atIdx < rootAtc.getAtomCount(); ++atIdx) {
                        if (!rootAtc.getAtom(atIdx).equals(partner)) continue;
                        if (atIdx < prevPos) {
                            implicitlyOrdered = false;
                        }
                        prevPos = atIdx;
                        break;
                    }
                    ++apoIdx;
                }
                if (implicitlyOrdered) continue;
                StringBuffer aalLine = new StringBuffer("M  AAL");
                for (atIdx = 0; atIdx < rootAtc.getAtomCount(); ++atIdx) {
                    if (!rootAtc.getAtom(atIdx).equals(rgroupAtom)) continue;
                    aalLine.append(MDLV2000Writer.formatMDLInt(atIdx + 1, 4));
                    aalLine.append(MDLV2000Writer.formatMDLInt(rApo.size(), 3));
                    apoIdx = 1;
                    while (rApo.get(apoIdx) != null) {
                        IAtom partner = ((IBond)rApo.get(apoIdx)).getConnectedAtom(rgroupAtom);
                        for (int a = 0; a < rootAtc.getAtomCount(); ++a) {
                            if (!rootAtc.getAtom(a).equals(partner)) continue;
                            aalLine.append(MDLV2000Writer.formatMDLInt(a + 1, 4));
                            aalLine.append(MDLV2000Writer.formatMDLInt(apoIdx, 4));
                        }
                        ++apoIdx;
                    }
                }
                rootBlock.append(aalLine.toString()).append(LSEP);
            }
            rootBlock.append("M  END").append(LSEP).append("$END CTAB").append(LSEP);
            StringBuffer rgpBlock = new StringBuffer();
            for (Integer rgrpNum : rGroupQuery.getRGroupDefinitions().keySet()) {
                List rgrpList = ((RGroupList)rGroupQuery.getRGroupDefinitions().get(rgrpNum)).getRGroups();
                if (rgrpList == null || rgrpList.size() == 0) continue;
                rgpBlock.append("$RGP").append(LSEP);
                rgpBlock.append(MDLV2000Writer.formatMDLInt(rgrpNum, 4)).append(LSEP);
                for (RGroup rgroup : rgrpList) {
                    rgpBlock.append("$CTAB").append(LSEP);
                    String ctab = this.getCTAB(rgroup.getGroup());
                    ctab = ctab.replaceAll(LSEP + "M  END" + LSEP, "");
                    rgpBlock.append(ctab).append(LSEP);
                    IAtom firstAttachmentPoint = rgroup.getFirstAttachmentPoint();
                    IAtom secondAttachmentPoint = rgroup.getSecondAttachmentPoint();
                    int apoCount = 0;
                    if (firstAttachmentPoint != null) {
                        int atIdx;
                        StringBuffer apoLine = new StringBuffer();
                        for (atIdx = 0; atIdx < rgroup.getGroup().getAtomCount(); ++atIdx) {
                            if (!rgroup.getGroup().getAtom(atIdx).equals(firstAttachmentPoint)) continue;
                            apoLine.append(MDLV2000Writer.formatMDLInt(atIdx + 1, 4));
                            ++apoCount;
                            if (secondAttachmentPoint != null && secondAttachmentPoint.equals(firstAttachmentPoint)) {
                                apoLine.append(MDLV2000Writer.formatMDLInt(3, 4));
                                continue;
                            }
                            apoLine.append(MDLV2000Writer.formatMDLInt(1, 4));
                        }
                        if (secondAttachmentPoint != null && !secondAttachmentPoint.equals(firstAttachmentPoint)) {
                            for (atIdx = 0; atIdx < rgroup.getGroup().getAtomCount(); ++atIdx) {
                                if (!rgroup.getGroup().getAtom(atIdx).equals(secondAttachmentPoint)) continue;
                                ++apoCount;
                                apoLine.append(MDLV2000Writer.formatMDLInt(atIdx + 1, 4));
                                apoLine.append(MDLV2000Writer.formatMDLInt(2, 4));
                            }
                        }
                        if (apoCount > 0) {
                            apoLine.insert(0, "M  APO" + MDLV2000Writer.formatMDLInt(apoCount, 3));
                            rgpBlock.append(apoLine).append(LSEP);
                        }
                    }
                    rgpBlock.append("M  END").append(LSEP);
                    rgpBlock.append("$END CTAB").append(LSEP);
                }
                rgpBlock.append("$END RGP").append(LSEP);
            }
            rgpBlock.append("$END MOL").append(LSEP);
            this.writer.write(rootBlock.toString());
            this.writer.write(rgpBlock.toString());
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CDKException("Unexpected exception when writing RGFile" + LSEP + e.getMessage());
        }
    }
}

