/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.List;
import java.util.Map;
import org.openscience.cdk.Bond;
import org.openscience.cdk.Ring;
import org.openscience.cdk.debug.DebugAtom;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugRing
extends Ring
implements IRing {
    private static final long serialVersionUID = -6420813246421544803L;
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugRing.class);

    public DebugRing() {
    }

    public DebugRing(int ringSize, String elementSymbol) {
        this(ringSize);
        this.atomCount = ringSize;
        this.bondCount = ringSize;
        this.atoms[0] = new DebugAtom(elementSymbol);
        for (int i = 1; i < ringSize; ++i) {
            this.atoms[i] = new DebugAtom(elementSymbol);
            this.bonds[i - 1] = new Bond(this.atoms[i - 1], this.atoms[i], IBond.Order.SINGLE);
        }
        this.bonds[ringSize - 1] = new Bond(this.atoms[ringSize - 1], this.atoms[0], IBond.Order.SINGLE);
    }

    public DebugRing(int ringSize) {
        super(ringSize);
    }

    public DebugRing(IAtomContainer container) {
        super(container);
    }

    public void addStereoElement(IStereoElement parity) {
        this.logger.debug((Object)"Adding stereo element: ", new Object[]{parity});
        super.addStereoElement(parity);
    }

    public Iterable<IStereoElement> stereoElements() {
        this.logger.debug((Object)"Getting stereo elements.");
        return super.stereoElements();
    }

    public void setAtoms(IAtom[] atoms) {
        this.logger.debug((Object)"Setting atoms: ", new Object[]{atoms.length});
        super.setAtoms(atoms);
    }

    public void setAtom(int number, IAtom atom) {
        this.logger.debug((Object)("Setting atom at: pos=" + number), new Object[]{" atom=" + atom});
        super.setAtom(number, atom);
    }

    public IAtom getAtom(int number) {
        this.logger.debug((Object)"Getting atom at: ", new Object[]{number});
        return super.getAtom(number);
    }

    public IBond getBond(int number) {
        this.logger.debug((Object)"Getting bond at: ", new Object[]{number});
        return super.getBond(number);
    }

    public ILonePair getLonePair(int number) {
        this.logger.debug((Object)"Getting lone pair at: ", new Object[]{number});
        return super.getLonePair(number);
    }

    public ISingleElectron getSingleElectron(int number) {
        this.logger.debug((Object)"Getting single electron at: ", new Object[]{number});
        return super.getSingleElectron(number);
    }

    public Iterable<IAtom> atoms() {
        this.logger.debug((Object)"Getting atoms iterator");
        return super.atoms();
    }

    public Iterable<IBond> bonds() {
        this.logger.debug((Object)"Getting bonds iterator");
        return super.bonds();
    }

    public Iterable<ILonePair> lonePairs() {
        this.logger.debug((Object)"Getting lone pairs iterator");
        return super.lonePairs();
    }

    public Iterable<ISingleElectron> singleElectrons() {
        this.logger.debug((Object)"Getting single electrons iterator");
        return super.singleElectrons();
    }

    public Iterable<IElectronContainer> electronContainers() {
        this.logger.debug((Object)"Getting electron containers iterator");
        return super.electronContainers();
    }

    public IAtom getFirstAtom() {
        this.logger.debug((Object)"Getting first atom: ", new Object[]{super.getFirstAtom()});
        return super.getFirstAtom();
    }

    public IAtom getLastAtom() {
        this.logger.debug((Object)"Getting last atom: ", new Object[]{super.getLastAtom()});
        return super.getLastAtom();
    }

    public int getAtomNumber(IAtom atom) {
        this.logger.debug((Object)"Getting atom number: ", new Object[]{atom});
        return super.getAtomNumber(atom);
    }

    public int getBondNumber(IAtom atom1, IAtom atom2) {
        this.logger.debug((Object)("Getting bond number: atom1=" + atom1), new Object[]{" atom2=" + atom2});
        return super.getBondNumber(atom1, atom2);
    }

    public int getBondNumber(IBond bond) {
        this.logger.debug((Object)"Getting bond number: ", new Object[]{bond});
        return super.getBondNumber(bond);
    }

    public int getLonePairNumber(ILonePair bond) {
        this.logger.debug((Object)"Getting lone pair number: ", new Object[]{bond});
        return super.getLonePairNumber(bond);
    }

    public int getSingleElectronNumber(ISingleElectron bond) {
        this.logger.debug((Object)"Getting single electron number: ", new Object[]{bond});
        return super.getSingleElectronNumber(bond);
    }

    public IElectronContainer getElectronContainer(int number) {
        this.logger.debug((Object)"Getting electron container at: ", new Object[]{number});
        return super.getElectronContainer(number);
    }

    public IBond getBond(IAtom atom1, IAtom atom2) {
        this.logger.debug((Object)("Getting bond for atoms: atom1=" + atom1), new Object[]{" atom2=" + atom2});
        return super.getBond(atom1, atom2);
    }

    public int getAtomCount() {
        this.logger.debug((Object)"Getting atom count");
        return super.getAtomCount();
    }

    public int getBondCount() {
        this.logger.debug((Object)"Getting bond count");
        return super.getBondCount();
    }

    public int getLonePairCount() {
        this.logger.debug((Object)"Getting lone pair count");
        return super.getLonePairCount();
    }

    public int getSingleElectronCount() {
        this.logger.debug((Object)"Getting single electron count");
        return super.getSingleElectronCount();
    }

    public int getElectronContainerCount() {
        this.logger.debug((Object)"Getting electron container count");
        return super.getElectronContainerCount();
    }

    public List<IAtom> getConnectedAtomsList(IAtom atom) {
        this.logger.debug((Object)"Getting connecting atoms vector for atom: ", new Object[]{atom});
        return super.getConnectedAtomsList(atom);
    }

    public List<IBond> getConnectedBondsList(IAtom atom) {
        this.logger.debug((Object)"Getting connected bonds vector for atom: ", new Object[]{atom});
        return super.getConnectedBondsList(atom);
    }

    public List<ILonePair> getConnectedLonePairsList(IAtom atom) {
        this.logger.debug((Object)("Getting lone pairs at atom: atom=" + atom), new Object[]{" lone pairs=" + super.getConnectedLonePairsCount(atom)});
        return super.getConnectedLonePairsList(atom);
    }

    public List<ISingleElectron> getConnectedSingleElectronsList(IAtom atom) {
        this.logger.debug((Object)("Getting single electrons at atom: atom=" + atom), new Object[]{" single electrons=" + super.getConnectedSingleElectronsCount(atom)});
        return super.getConnectedSingleElectronsList(atom);
    }

    public List<IElectronContainer> getConnectedElectronContainersList(IAtom atom) {
        this.logger.debug((Object)"Getting connected electron containers for atom: ", new Object[]{atom});
        return super.getConnectedElectronContainersList(atom);
    }

    public int getConnectedAtomsCount(IAtom atom) {
        this.logger.debug((Object)"Getting connected atoms count for atom: ", new Object[]{atom});
        return super.getConnectedAtomsCount(atom);
    }

    public int getConnectedBondsCount(IAtom atom) {
        this.logger.debug((Object)"Getting connected bonds count for atom: ", new Object[]{atom});
        return super.getConnectedBondsCount(atom);
    }

    public int getConnectedLonePairsCount(IAtom atom) {
        this.logger.debug((Object)"Getting connected lone pairs count for atom: ", new Object[]{atom});
        return super.getConnectedLonePairsCount(atom);
    }

    public int getConnectedSingleElectronsCount(IAtom atom) {
        this.logger.debug((Object)"Getting connected single electrons count for atom: ", new Object[]{atom});
        return super.getConnectedSingleElectronsCount(atom);
    }

    public double getBondOrderSum(IAtom atom) {
        this.logger.debug((Object)"Getting bond order sum for atom: ", new Object[]{atom});
        return super.getBondOrderSum(atom);
    }

    public IBond.Order getMaximumBondOrder(IAtom atom) {
        this.logger.debug((Object)"Getting maximum bond order for atom: ", new Object[]{atom});
        return super.getMaximumBondOrder(atom);
    }

    public IBond.Order getMinimumBondOrder(IAtom atom) {
        this.logger.debug((Object)"Getting minimum bond order for atom: ", new Object[]{atom});
        return super.getMinimumBondOrder(atom);
    }

    public void add(IAtomContainer atomContainer) {
        this.logger.debug((Object)"Adding atom container: ", new Object[]{atomContainer});
        super.add(atomContainer);
    }

    public void addAtom(IAtom atom) {
        this.logger.debug((Object)"Adding atom: ", new Object[]{atom});
        super.addAtom(atom);
    }

    public void addBond(IBond bond) {
        this.logger.debug((Object)"Adding bond: ", new Object[]{bond});
        super.addBond(bond);
    }

    public void addLonePair(ILonePair ec) {
        this.logger.debug((Object)"Adding lone pair: ", new Object[]{ec});
        super.addLonePair(ec);
    }

    public void addSingleElectron(ISingleElectron ec) {
        this.logger.debug((Object)"Adding single electron: ", new Object[]{ec});
        super.addSingleElectron(ec);
    }

    public void addElectronContainer(IElectronContainer electronContainer) {
        this.logger.debug((Object)"Adding electron container: ", new Object[]{electronContainer});
        super.addElectronContainer(electronContainer);
    }

    public void remove(IAtomContainer atomContainer) {
        this.logger.debug((Object)"Removing atom container: ", new Object[]{atomContainer});
        super.remove(atomContainer);
    }

    public IElectronContainer removeElectronContainer(int position) {
        this.logger.debug((Object)"Removing electronContainer: ", new Object[]{position});
        return super.removeElectronContainer(position);
    }

    public void removeElectronContainer(IElectronContainer electronContainer) {
        this.logger.debug((Object)"Removing electron container: ", new Object[]{electronContainer});
        super.removeElectronContainer(electronContainer);
    }

    public void removeAtom(int position) {
        this.logger.debug((Object)"Removing atom: ", new Object[]{position});
        super.removeAtom(position);
    }

    public void removeAtom(IAtom atom) {
        this.logger.debug((Object)"Removing atom: ", new Object[]{atom});
        super.removeAtom(atom);
    }

    public IBond removeBond(int pos) {
        this.logger.debug((Object)("Removing bond at " + pos));
        return super.removeBond(pos);
    }

    public IBond removeBond(IAtom atom1, IAtom atom2) {
        this.logger.debug((Object)("Removing bond: atom1=" + atom1 + " atom2=" + atom2));
        return super.removeBond(atom1, atom2);
    }

    public void removeBond(IBond bond) {
        this.logger.debug((Object)("Removing bond=" + bond));
        super.removeBond(bond);
    }

    public ILonePair removeLonePair(int pos) {
        this.logger.debug((Object)("Removing bond at " + pos));
        return super.removeLonePair(pos);
    }

    public void removeLonePair(ILonePair ec) {
        this.logger.debug((Object)("Removing bond=" + ec));
        super.removeLonePair(ec);
    }

    public ISingleElectron removeSingleElectron(int pos) {
        this.logger.debug((Object)("Removing bond at " + pos));
        return super.removeSingleElectron(pos);
    }

    public void removeSingleElectron(ISingleElectron ec) {
        this.logger.debug((Object)("Removing bond=" + ec));
        super.removeSingleElectron(ec);
    }

    public void removeAtomAndConnectedElectronContainers(IAtom atom) {
        this.logger.debug((Object)"Removing atom and connected electron containers: ", new Object[]{atom});
        super.removeAtomAndConnectedElectronContainers(atom);
    }

    public void removeAllElements() {
        this.logger.debug((Object)"Removing all elements");
        super.removeAllElements();
    }

    public void removeAllElectronContainers() {
        this.logger.debug((Object)"Removing all electron containers");
        super.removeAllElectronContainers();
    }

    public void removeAllBonds() {
        this.logger.debug((Object)"Removing all bonds");
        super.removeAllBonds();
    }

    public void addBond(int atom1, int atom2, IBond.Order order, IBond.Stereo stereo) {
        this.logger.debug((Object)("Adding bond: atom1=" + atom1 + " atom2=" + atom2), new Object[]{" order=" + order + " stereo=" + stereo});
        super.addBond(atom1, atom2, order, stereo);
    }

    public void addBond(int atom1, int atom2, IBond.Order order) {
        this.logger.debug((Object)("Adding bond: atom1=" + atom1 + " atom2=" + atom2), new Object[]{" order=" + order});
        super.addBond(atom1, atom2, order);
    }

    public void addLonePair(int atomID) {
        this.logger.debug((Object)"Adding lone pair: ", new Object[]{atomID});
        super.addLonePair(atomID);
    }

    public void addSingleElectron(int atomID) {
        this.logger.debug((Object)"Adding single electron: ", new Object[]{atomID});
        super.addSingleElectron(atomID);
    }

    public boolean contains(IAtom atom) {
        this.logger.debug((Object)"Contains atom: ", new Object[]{atom});
        return super.contains(atom);
    }

    public boolean contains(IBond bond) {
        this.logger.debug((Object)"Contains bond: ", new Object[]{bond});
        return super.contains(bond);
    }

    public boolean contains(ILonePair ec) {
        this.logger.debug((Object)"Contains lone pair: ", new Object[]{ec});
        return super.contains(ec);
    }

    public boolean contains(ISingleElectron ec) {
        this.logger.debug((Object)"Contains single electron: ", new Object[]{ec});
        return super.contains(ec);
    }

    public boolean contains(IElectronContainer electronContainer) {
        this.logger.debug((Object)"Contains electron container: ", new Object[]{electronContainer});
        return super.contains(electronContainer);
    }

    public void addListener(IChemObjectListener col) {
        this.logger.debug((Object)"Adding listener: ", new Object[]{col});
        super.addListener(col);
    }

    public int getListenerCount() {
        this.logger.debug((Object)"Getting listener count: ", new Object[]{super.getListenerCount()});
        return super.getListenerCount();
    }

    public void removeListener(IChemObjectListener col) {
        this.logger.debug((Object)"Removing listener: ", new Object[]{col});
        super.removeListener(col);
    }

    public void notifyChanged() {
        this.logger.debug((Object)"Notifying changed");
        super.notifyChanged();
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug((Object)"Notifying changed event: ", new Object[]{evt});
        super.notifyChanged(evt);
    }

    public void setProperty(Object description, Object property) {
        this.logger.debug((Object)"Setting property: ", new Object[]{description + "=" + property});
        super.setProperty(description, property);
    }

    public void removeProperty(Object description) {
        this.logger.debug((Object)"Removing property: ", new Object[]{description});
        super.removeProperty(description);
    }

    public <T> T getProperty(Object description) {
        this.logger.debug((Object)"Getting property: ", new Object[]{description + "=" + super.getProperty(description)});
        return (T)super.getProperty(description);
    }

    public Map<Object, Object> getProperties() {
        this.logger.debug((Object)"Getting properties");
        return super.getProperties();
    }

    public String getID() {
        this.logger.debug((Object)"Getting ID: ", new Object[]{super.getID()});
        return super.getID();
    }

    public void setID(String identifier) {
        this.logger.debug((Object)"Setting ID: ", new Object[]{identifier});
        super.setID(identifier);
    }

    public void setFlag(int flag_type, boolean flag_value) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flag_type + "=" + flag_value});
        super.setFlag(flag_type, flag_value);
    }

    public boolean getFlag(int flag_type) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flag_type + "=" + super.getFlag(flag_type)});
        return super.getFlag(flag_type);
    }

    public void addProperties(Map<Object, Object> properties) {
        this.logger.debug((Object)"Setting properties: ", new Object[]{properties});
        super.addProperties(properties);
    }

    public void setFlags(boolean[] flagsNew) {
        this.logger.debug((Object)"Setting flags:", new Object[]{flagsNew.length});
        super.setFlags(flagsNew);
    }

    public boolean[] getFlags() {
        this.logger.debug((Object)"Getting flags:", new Object[]{super.getFlags().length});
        return super.getFlags();
    }

    public IRing clone() throws CloneNotSupportedException {
        IRing clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error((Object)("Could not clone DebugAtom: " + exception.getMessage()), new Object[]{exception});
            this.logger.debug((Object)exception);
        }
        return clone;
    }

    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    public int getRingSize() {
        this.logger.debug((Object)"Getting Ring size:", new Object[]{super.getRingSize()});
        return super.getRingSize();
    }

    public IBond getNextBond(IBond bond, IAtom atom) {
        this.logger.debug((Object)"Getting next bond: ", new Object[]{super.getNextBond(bond, atom)});
        return super.getNextBond(bond, atom);
    }

    public int getBondOrderSum() {
        this.logger.debug((Object)"Getting order sum: ", new Object[]{super.getBondOrderSum()});
        return super.getBondOrderSum();
    }

    public void stateChanged(IChemObjectChangeEvent event) {
        this.logger.debug((Object)"State changed: ", new Object[]{event});
        super.stateChanged(event);
    }
}

