/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionScheme;
import org.openscience.cdk.silent.ReactionSet;

public class ReactionScheme
extends ReactionSet
implements IReactionScheme {
    private List<IReactionScheme> reactionScheme = new ArrayList<IReactionScheme>();
    private static final long serialVersionUID = -3676327644698347260L;

    @TestMethod(value="testAdd_IReactionScheme")
    public void add(IReactionScheme scheme) {
        this.reactionScheme.add(scheme);
    }

    @TestMethod(value="testReactionSchemes")
    public Iterable<IReactionScheme> reactionSchemes() {
        return this.reactionScheme;
    }

    @TestMethod(value="testGetReactionSchemeCount")
    public int getReactionSchemeCount() {
        return this.reactionScheme.size();
    }

    @TestMethod(value="testRemoveAllReactionSchemes")
    public void removeAllReactionSchemes() {
        this.reactionScheme.clear();
    }

    @TestMethod(value="testRemoveReactionScheme_IReactionScheme")
    public void removeReactionScheme(IReactionScheme scheme) {
        this.reactionScheme.remove(scheme);
    }

    @Override
    @TestMethod(value="testClone")
    public Object clone() throws CloneNotSupportedException {
        ReactionScheme clone = new ReactionScheme();
        for (IReactionScheme scheme : this.reactionSchemes()) {
            clone.add((IReactionScheme)scheme.clone());
        }
        for (IReaction reaction : this.reactions()) {
            clone.addReaction((IReaction)reaction.clone());
        }
        if (this.getProperties() != null) {
            Map<Object, Object> properties = this.getProperties();
            HashMap<Object, Object> clonedHashtable = new HashMap<Object, Object>();
            for (Object key : properties.keySet()) {
                Object value = properties.get(key);
                clonedHashtable.put(key, value);
            }
            clone.addProperties(clonedHashtable);
        }
        return clone;
    }
}

