/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.Comparator;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;

public class AtomContainerComparatorBy2DCenter
implements Comparator<IAtomContainer> {
    private static final Point2d MAXIMUM = new Point2d(Double.MAX_VALUE, Double.MAX_VALUE);

    @Override
    public int compare(IAtomContainer a, IAtomContainer b) {
        Point2d p1 = AtomContainerComparatorBy2DCenter.center(a);
        Point2d p2 = AtomContainerComparatorBy2DCenter.center(b);
        if (p1.x > p2.x) {
            return 1;
        }
        if (p1.x < p2.x) {
            return -1;
        }
        if (p1.y > p2.y) {
            return 1;
        }
        if (p1.y < p2.y) {
            return -1;
        }
        return 0;
    }

    private static Point2d center(IAtomContainer container) {
        return container != null ? GeometryTools.get2DCenter(container) : MAXIMUM;
    }
}

