/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.charges.Electronegativity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class SigmaElectronegativityDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private int maxIterations = 0;
    private static final String[] NAMES = new String[]{"elecSigmA"};
    private Electronegativity electronegativity = new Electronegativity();

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#sigmaElectronegativity", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("SigmaElectronegativityDescriptor only expects one parameter");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter must be of type Integer");
        }
        if (params.length == 0) {
            return;
        }
        this.maxIterations = (Integer)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public DescriptorValue calculate(IAtom atom, IAtomContainer ac) {
        IAtom localAtom;
        IAtomContainer clone;
        try {
            clone = ac.clone();
            localAtom = clone.getAtom(ac.indexOf(atom));
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(clone);
        }
        catch (CDKException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), NAMES, e);
        }
        catch (CloneNotSupportedException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), NAMES, e);
        }
        if (this.maxIterations != -1 && this.maxIterations != 0) {
            this.electronegativity.setMaxIterations(this.maxIterations);
        }
        double result = this.electronegativity.calculateSigmaElectronegativity(clone, localAtom);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(result), NAMES);
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        return 0;
    }
}

