/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.n3.N3JenaWriterCommon;
import com.hp.hpl.jena.n3.N3JenaWriterPP;
import com.hp.hpl.jena.n3.N3JenaWriterTriples;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import java.io.OutputStream;
import java.io.Writer;

public class N3JenaWriter
implements RDFWriter {
    public static boolean DEBUG = false;
    protected static final String propBase = "http://jena.hpl.hp.com/n3/properties/";
    public static final String propWriterName = "http://jena.hpl.hp.com/n3/properties/writer";
    public static final String n3Writer = "N3";
    public static final String n3WriterPrettyPrinter = "N3-PP";
    public static final String n3WriterPlain = "N3-PLAIN";
    public static final String n3WriterTriples = "N3-TRIPLES";
    public static final String n3WriterTriplesAlt = "N3-TRIPLE";
    public static final String turtleWriter = "TURTLE";
    public static final String turtleWriterAlt1 = "Turtle";
    public static final String turtleWriterAlt2 = "TTL";
    protected N3JenaWriterCommon writer = null;

    public N3JenaWriter() {
        this.writer = this.chooseWriter();
    }

    public N3JenaWriter(N3JenaWriterCommon w) {
        this.writer = w;
    }

    N3JenaWriterCommon chooseWriter() {
        String writerName = JenaRuntime.getSystemProperty(propWriterName);
        if (writerName == null || writerName.equals(n3Writer) || writerName.equals(n3WriterPrettyPrinter)) {
            return new N3JenaWriterPP();
        }
        if (writerName.equalsIgnoreCase(n3WriterPlain)) {
            return new N3JenaWriterCommon();
        }
        if (writerName.equalsIgnoreCase(n3WriterTriples) || writerName.equalsIgnoreCase(n3WriterTriplesAlt)) {
            return new N3JenaWriterTriples();
        }
        if (writerName.equalsIgnoreCase(turtleWriter)) {
            N3JenaWriterPP w = new N3JenaWriterPP();
            w.useWellKnownPropertySymbols = false;
            return w;
        }
        return new N3JenaWriterPP();
    }

    @Override
    public void write(Model model, Writer out, String base) {
        this.writer.write(model, out, base);
    }

    @Override
    public void write(Model model, OutputStream out, String base) {
        this.writer.write(model, out, base);
    }

    @Override
    public Object setProperty(String propName, Object propValue) {
        return this.writer.setProperty(propName, propValue);
    }

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        return this.writer.setErrorHandler(errHandler);
    }
}

