/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash.stereo;

import javax.vecmath.Point2d;
import org.openscience.cdk.hash.stereo.GeometricParity;

final class Tetrahedral2DParity
extends GeometricParity {
    private final Point2d[] coordinates;
    private final int[] elevations;

    public Tetrahedral2DParity(Point2d[] coordinates, int[] elevations) {
        if (coordinates.length != 4 || elevations.length != 4) {
            throw new IllegalArgumentException("4 coordinates/elevations expected");
        }
        this.coordinates = coordinates;
        this.elevations = elevations;
    }

    @Override
    public int parity() {
        double x1 = this.coordinates[0].x;
        double x2 = this.coordinates[1].x;
        double x3 = this.coordinates[2].x;
        double x4 = this.coordinates[3].x;
        double y1 = this.coordinates[0].y;
        double y2 = this.coordinates[1].y;
        double y3 = this.coordinates[2].y;
        double y4 = this.coordinates[3].y;
        double det = (double)this.elevations[0] * Tetrahedral2DParity.det(x2, y2, x3, y3, x4, y4) - (double)this.elevations[1] * Tetrahedral2DParity.det(x1, y1, x3, y3, x4, y4) + (double)this.elevations[2] * Tetrahedral2DParity.det(x1, y1, x2, y2, x4, y4) - (double)this.elevations[3] * Tetrahedral2DParity.det(x1, y1, x2, y2, x3, y3);
        return (int)Math.signum(det);
    }

    private static double det(double xa, double ya, double xb, double yb, double xc, double yc) {
        return (xa - xc) * (yb - yc) - (ya - yc) * (xb - xc);
    }
}

