/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.enhanced;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.enhanced.Polymorphic;
import com.hp.hpl.jena.enhanced.UnsupportedPolymorphismException;
import com.hp.hpl.jena.graph.FrontsNode;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.RDFNode;

public class EnhNode
extends Polymorphic<RDFNode>
implements FrontsNode {
    protected final Node node;
    protected final EnhGraph enhGraph;

    public EnhNode(Node n, EnhGraph g) {
        this.node = n;
        this.enhGraph = g;
    }

    @Override
    public Node asNode() {
        return this.node;
    }

    public EnhGraph getGraph() {
        return this.enhGraph;
    }

    public final boolean isAnon() {
        return this.node.isBlank();
    }

    public final boolean isLiteral() {
        return this.node.isLiteral();
    }

    public final boolean isURIResource() {
        return this.node.isURI();
    }

    public final boolean isResource() {
        return this.node.isURI() || this.node.isBlank();
    }

    public <X extends RDFNode> X viewAs(Class<X> t) {
        return (X)((RDFNode)this.asInternal(t));
    }

    public <T extends RDFNode> T as(Class<T> t) {
        return (T)((RDFNode)this.asInternal(t));
    }

    public <X extends RDFNode> boolean canAs(Class<X> t) {
        return this.canSupport(t);
    }

    public final int hashCode() {
        return this.node.hashCode();
    }

    @Override
    public final boolean equals(Object o) {
        return o instanceof FrontsNode && this.node.equals(((FrontsNode)o).asNode());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    protected <X extends RDFNode> X convertTo(Class<X> t) {
        EnhGraph eg = this.getGraph();
        if (eg == null) {
            throw new UnsupportedPolymorphismException(this, t);
        }
        Implementation imp = this.getPersonality().getImplementation(t);
        if (imp == null) {
            throw new UnsupportedPolymorphismException(this, t);
        }
        EnhNode result = imp.wrap(this.asNode(), eg);
        this.addView(result);
        return (X)((RDFNode)t.cast(result));
    }

    @Override
    protected <X extends RDFNode> boolean canSupport(Class<X> t) {
        if (this.alreadyHasView(t)) {
            return true;
        }
        if (this.getGraph() == null) {
            return false;
        }
        Implementation imp = this.getPersonality().getImplementation(t);
        return imp == null ? false : imp.canWrap(this.asNode(), this.getGraph());
    }

    @Override
    protected Personality<RDFNode> getPersonality() {
        return this.getGraph().getPersonality();
    }
}

