/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class CDK {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(CDK.class);
    private static final String RESOURCE_LOCATION = "/build.props";
    private static volatile String version;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        if (version != null) {
            return version;
        }
        try (InputStream stream = CDK.class.getResourceAsStream(RESOURCE_LOCATION);){
            if (stream == null) {
                version = CDK.class.getPackage().getImplementationVersion();
            }
            Properties props = new Properties();
            props.load(stream);
            String string = version = props.getProperty("version");
            return string;
        }
        catch (IOException exception) {
            logger.error("Error while loading the build.props file: ", exception.getMessage());
            logger.debug(exception);
            return null;
        }
    }
}

