/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Monomer;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IPolymer;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.tools.manipulator.SgroupManipulator;

public class Polymer
extends AtomContainer
implements Serializable,
IPolymer {
    private static final long serialVersionUID = -2596790658835319339L;
    private Map<String, IMonomer> monomers = new Hashtable<String, IMonomer>();

    @Override
    public void addAtom(IAtom oAtom, IMonomer oMonomer) {
        if (!this.contains(oAtom)) {
            super.addAtom(oAtom);
            if (oMonomer != null) {
                oMonomer.addAtom(oAtom);
                if (!this.monomers.containsKey(oMonomer.getMonomerName())) {
                    this.monomers.put(oMonomer.getMonomerName(), oMonomer);
                }
            }
        }
    }

    @Override
    public int getMonomerCount() {
        return this.monomers.size();
    }

    @Override
    public IMonomer getMonomer(String cName) {
        return this.monomers.get(cName);
    }

    @Override
    public Collection<String> getMonomerNames() {
        return this.monomers.keySet();
    }

    @Override
    public void removeMonomer(String name) {
        if (this.monomers.containsKey(name)) {
            Monomer monomer = (Monomer)this.monomers.get(name);
            this.remove(monomer);
            this.monomers.remove(name);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringContent = new StringBuffer();
        stringContent.append("Polymer(");
        stringContent.append(this.hashCode()).append(", ");
        stringContent.append(super.toString());
        stringContent.append(')');
        return stringContent.toString();
    }

    @Override
    public IPolymer clone() throws CloneNotSupportedException {
        Polymer clone = (Polymer)super.clone();
        clone.removeAllElements();
        clone.monomers = new Hashtable<String, IMonomer>();
        for (String monomerName : this.getMonomerNames()) {
            Monomer monomerClone = (Monomer)this.getMonomer(monomerName).clone();
            for (IAtom atomInMonomer : monomerClone.atoms()) {
                clone.addAtom(atomInMonomer, monomerClone);
            }
        }
        HashMap<IAtom, IAtom> atomMap = new HashMap<IAtom, IAtom>(this.atomCount >= 3 ? this.atomCount + this.atomCount / 3 : this.atomCount + 1);
        HashMap<IBond, IBond> bondMap = new HashMap<IBond, IBond>(this.bondCount >= 3 ? this.bondCount + this.bondCount / 3 : this.bondCount + 1);
        for (IAtom iAtom : this.atoms()) {
            if (this.atomIsInMonomer(iAtom)) continue;
            IAtom cloned = iAtom.clone();
            clone.addAtom(cloned);
            atomMap.put(iAtom, cloned);
        }
        for (IBond bond : this.bonds()) {
            IBond newBond = bond.clone();
            IAtom[] newAtoms = new IAtom[bond.getAtomCount()];
            for (int j = 0; j < bond.getAtomCount(); ++j) {
                newAtoms[j] = (IAtom)atomMap.get(bond.getAtom(j));
            }
            newBond.setAtoms(newAtoms);
            clone.addBond(newBond);
            bondMap.put(bond, newBond);
        }
        for (int i = 0; i < this.getLonePairCount(); ++i) {
            ILonePair iLonePair = this.getLonePair(i);
            ILonePair newLp = (ILonePair)iLonePair.clone();
            if (iLonePair.getAtom() != null) {
                newLp.setAtom((IAtom)atomMap.get(iLonePair.getAtom()));
            }
            clone.addLonePair(newLp);
        }
        for (int i = 0; i < this.getSingleElectronCount(); ++i) {
            ISingleElectron singleElectron = this.getSingleElectron(i);
            ISingleElectron newSingleElectron = (ISingleElectron)singleElectron.clone();
            if (singleElectron.getAtom() != null) {
                newSingleElectron.setAtom((IAtom)atomMap.get(singleElectron.getAtom()));
            }
            clone.addSingleElectron(newSingleElectron);
        }
        for (IStereoElement element : this.stereoElements) {
            clone.addStereoElement(element.map(atomMap, bondMap));
        }
        Collection sgroups = (Collection)this.getProperty("cdk:CtabSgroups");
        if (sgroups != null) {
            HashMap<IChemObject, IChemObject> replace = new HashMap<IChemObject, IChemObject>();
            replace.putAll(atomMap);
            replace.putAll(bondMap);
            clone.setProperty("cdk:CtabSgroups", SgroupManipulator.copy(sgroups, replace));
        }
        return clone;
    }

    private boolean atomIsInMonomer(IAtom atom) {
        for (String monomerName : this.getMonomerNames()) {
            IMonomer monomer = this.getMonomer(monomerName);
            if (!monomer.contains(atom)) continue;
            return true;
        }
        return false;
    }
}

