/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.protein.data;

import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IPDBAtom;

public class PDBAtom
extends Atom
implements Cloneable,
IPDBAtom {
    private static final long serialVersionUID = 7670650135045832543L;
    private String record;
    private double tempFactor;
    private String resName;
    private String iCode;
    private double occupancy;
    private String name;
    private String chainID;
    private String altLoc;
    private String segID;
    private int serial;
    private String resSeq;
    private boolean oxt;
    private boolean hetAtom;

    public PDBAtom(IElement element) {
        super(element);
        this.initValues();
    }

    public PDBAtom(String symbol) {
        super(symbol);
        this.initValues();
    }

    public PDBAtom(String symbol, Point3d coordinate) {
        super(symbol, coordinate);
        this.initValues();
    }

    private void initValues() {
        this.record = null;
        this.tempFactor = -1.0;
        this.resName = null;
        this.iCode = null;
        this.occupancy = -1.0;
        this.name = null;
        this.chainID = null;
        this.altLoc = null;
        this.segID = null;
        this.serial = 0;
        this.resSeq = null;
        this.oxt = false;
        this.hetAtom = false;
        this.hydrogenCount = null;
        this.charge = 0.0;
        this.formalCharge = 0;
    }

    @Override
    public String getRecord() {
        return this.record;
    }

    @Override
    public void setRecord(String newRecord) {
        this.record = newRecord;
    }

    @Override
    public Double getTempFactor() {
        return this.tempFactor;
    }

    @Override
    public void setTempFactor(Double newTempFactor) {
        this.tempFactor = newTempFactor;
    }

    @Override
    public void setResName(String newResName) {
        this.resName = newResName;
    }

    @Override
    public String getResName() {
        return this.resName;
    }

    @Override
    public void setICode(String newICode) {
        this.iCode = newICode;
    }

    @Override
    public String getICode() {
        return this.iCode;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setChainID(String newChainID) {
        this.chainID = newChainID;
    }

    @Override
    public String getChainID() {
        return this.chainID;
    }

    @Override
    public void setAltLoc(String newAltLoc) {
        this.altLoc = newAltLoc;
    }

    @Override
    public String getAltLoc() {
        return this.altLoc;
    }

    @Override
    public void setSegID(String newSegID) {
        this.segID = newSegID;
    }

    @Override
    public String getSegID() {
        return this.segID;
    }

    @Override
    public void setSerial(Integer newSerial) {
        this.serial = newSerial;
    }

    @Override
    public Integer getSerial() {
        return this.serial;
    }

    @Override
    public void setResSeq(String newResSeq) {
        this.resSeq = newResSeq;
    }

    @Override
    public String getResSeq() {
        return this.resSeq;
    }

    @Override
    public void setOxt(Boolean newOxt) {
        this.oxt = newOxt;
    }

    @Override
    public Boolean getOxt() {
        return this.oxt;
    }

    @Override
    public void setHetAtom(Boolean newHetAtom) {
        this.hetAtom = newHetAtom;
    }

    @Override
    public Boolean getHetAtom() {
        return this.hetAtom;
    }

    @Override
    public void setOccupancy(Double newOccupancy) {
        this.occupancy = newOccupancy;
    }

    @Override
    public Double getOccupancy() {
        return this.occupancy;
    }

    @Override
    public String toString() {
        StringBuilder description = new StringBuilder(150);
        description.append("PDBAtom(");
        description.append(this.hashCode());
        description.append(", altLoc=").append(this.getAltLoc());
        description.append(", chainID=").append(this.getChainID());
        description.append(", iCode=").append(this.getICode());
        description.append(", name=").append(this.getName());
        description.append(", resName=").append(this.getResName());
        description.append(", resSeq=").append(this.getResSeq());
        description.append(", segID=").append(this.getSegID());
        description.append(", serial=").append(this.getSerial());
        description.append(", tempFactor=").append(this.getTempFactor());
        description.append(", oxt=").append(this.getOxt());
        description.append(", hetatm=").append(this.getHetAtom()).append(", ");
        description.append(super.toString());
        description.append(')');
        return description.toString();
    }
}

