/*
 * Decompiled with CFR 0.152.
 */
package signature;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import signature.DAG;
import signature.DAGVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalLabellingVisitor
implements DAGVisitor {
    private int[] labelling;
    private int currentLabel;
    private Comparator<DAG.Node> comparator;

    public CanonicalLabellingVisitor(int vertexCount, Comparator<DAG.Node> comparator) {
        this.labelling = new int[vertexCount];
        Arrays.fill(this.labelling, -1);
        this.currentLabel = 0;
    }

    @Override
    public void visit(DAG.Node node) {
        if (this.labelling[node.vertexIndex] == -1) {
            this.labelling[node.vertexIndex] = this.currentLabel++;
        }
        if (this.comparator != null) {
            Collections.sort(node.children, this.comparator);
        }
        for (DAG.Node child : node.children) {
            child.accept(this);
        }
    }

    public int[] getLabelling() {
        return this.labelling;
    }
}

