/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula.rules;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.formula.rules.IRule;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class ToleranceRangeRule
implements IRule {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(ToleranceRangeRule.class);
    private double mass = 0.0;
    private double tolerance = 0.05;

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 2) {
            throw new CDKException("ToleranceRangeRule expects only two parameter");
        }
        if (!(params[0] instanceof Double)) {
            throw new CDKException("The parameter 0 must be of type Double");
        }
        if (!(params[1] instanceof Double)) {
            throw new CDKException("The parameter 1 must be of type Double");
        }
        this.mass = (Double)params[0];
        this.tolerance = (Double)params[1];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.mass, this.tolerance};
        return params;
    }

    @Override
    public double validate(IMolecularFormula formula) throws CDKException {
        logger.info((Object)"Start validation of ", new Object[]{formula});
        double totalExactMass = MolecularFormulaManipulator.getTotalExactMass(formula);
        if (Math.abs(totalExactMass - this.mass) > this.tolerance) {
            return 0.0;
        }
        return 1.0;
    }
}

