/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.Bond;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugBond
extends Bond
implements IBond {
    private static final long serialVersionUID = -2330398179697796261L;
    final ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugBond.class);

    public DebugBond() {
    }

    public DebugBond(IAtom atom1, IAtom atom2) {
        super(atom1, atom2);
    }

    public DebugBond(IAtom atom1, IAtom atom2, IBond.Order order) {
        super(atom1, atom2, order);
    }

    public DebugBond(IAtom atom1, IAtom atom2, IBond.Order order, IBond.Stereo stereo) {
        super(atom1, atom2, order, stereo);
    }

    public DebugBond(IAtom[] atoms) {
        super(atoms);
    }

    public DebugBond(IAtom[] atoms, IBond.Order order) {
        super(atoms, order);
    }

    public Integer getElectronCount() {
        this.logger.debug((Object)"Getting electron count: ", new Object[]{super.getElectronCount()});
        return super.getElectronCount();
    }

    public void setElectronCount(Integer electronCount) {
        this.logger.debug((Object)"Setting electron count: ", new Object[]{electronCount});
        super.setElectronCount(electronCount);
    }

    public void addListener(IChemObjectListener col) {
        this.logger.debug((Object)"Adding listener: ", new Object[]{col});
        super.addListener(col);
    }

    public int getListenerCount() {
        this.logger.debug((Object)"Getting listener count: ", new Object[]{super.getListenerCount()});
        return super.getListenerCount();
    }

    public void removeListener(IChemObjectListener col) {
        this.logger.debug((Object)"Removing listener: ", new Object[]{col});
        super.removeListener(col);
    }

    public void notifyChanged() {
        this.logger.debug((Object)"Notifying changed");
        super.notifyChanged();
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug((Object)"Notifying changed event: ", new Object[]{evt});
        super.notifyChanged(evt);
    }

    public void setProperty(Object description, Object property) {
        this.logger.debug((Object)"Setting property: ", new Object[]{description + "=" + property});
        super.setProperty(description, property);
    }

    public void removeProperty(Object description) {
        this.logger.debug((Object)"Removing property: ", new Object[]{description});
        super.removeProperty(description);
    }

    public <T> T getProperty(Object description) {
        this.logger.debug((Object)"Getting property: ", new Object[]{description + "=" + super.getProperty(description)});
        return (T)super.getProperty(description);
    }

    public Map<Object, Object> getProperties() {
        this.logger.debug((Object)"Getting properties");
        return super.getProperties();
    }

    public String getID() {
        this.logger.debug((Object)"Getting ID: ", new Object[]{super.getID()});
        return super.getID();
    }

    public void setID(String identifier) {
        this.logger.debug((Object)"Setting ID: ", new Object[]{identifier});
        super.setID(identifier);
    }

    public void setFlag(int flagType, boolean flagValue) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flagType + "=" + flagValue});
        super.setFlag(flagType, flagValue);
    }

    public boolean getFlag(int flagType) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flagType + "=" + super.getFlag(flagType)});
        return super.getFlag(flagType);
    }

    public void addProperties(Map<Object, Object> properties) {
        this.logger.debug((Object)"Setting properties: ", new Object[]{properties});
        super.addProperties(properties);
    }

    public void setFlags(boolean[] flagsNew) {
        this.logger.debug((Object)"Setting flags:", new Object[]{flagsNew.length});
        super.setFlags(flagsNew);
    }

    public boolean[] getFlags() {
        this.logger.debug((Object)"Getting flags:", new Object[]{super.getFlags().length});
        return super.getFlags();
    }

    public IBond clone() throws CloneNotSupportedException {
        IBond clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error((Object)("Could not clone DebugAtom: " + exception.getMessage()), new Object[]{exception});
            this.logger.debug((Object)exception);
        }
        return clone;
    }

    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    public Iterable<IAtom> atoms() {
        this.logger.debug((Object)"Getting atoms iterable");
        return super.atoms();
    }

    public void setAtoms(IAtom[] atoms) {
        this.logger.debug((Object)"Setting atoms: ", new Object[]{atoms.length});
        super.setAtoms(atoms);
    }

    public int getAtomCount() {
        this.logger.debug((Object)"Getting atom count: ", new Object[]{super.getAtomCount()});
        return super.getAtomCount();
    }

    public IAtom getAtom(int position) {
        this.logger.debug((Object)"Getting atom at position: ", new Object[]{position});
        return super.getAtom(position);
    }

    public IAtom getBegin() {
        this.logger.debug((Object)"Getting begin atom");
        return super.getBegin();
    }

    public IAtom getEnd() {
        this.logger.debug((Object)"Getting end atom");
        return super.getEnd();
    }

    public IAtom getOther(IAtom atom) {
        this.logger.debug((Object)"Getting connected atom to atom: ", new Object[]{atom});
        return super.getOther(atom);
    }

    public boolean contains(IAtom atom) {
        this.logger.debug((Object)"Contains atom: ", new Object[]{atom});
        return super.contains(atom);
    }

    public void setAtom(IAtom atom, int position) {
        this.logger.debug((Object)"Setting atom at position: ", new Object[]{atom});
        super.setAtom(atom, position);
    }

    public IBond.Order getOrder() {
        this.logger.debug((Object)"Getting order: ", new Object[]{super.getOrder()});
        return super.getOrder();
    }

    public void setOrder(IBond.Order order) {
        this.logger.debug((Object)"Setting order: ", new Object[]{order});
        super.setOrder(order);
    }

    public IBond.Stereo getStereo() {
        this.logger.debug((Object)"Getting stereo: ", new Object[]{super.getStereo()});
        return super.getStereo();
    }

    public void setStereo(IBond.Stereo stereo) {
        this.logger.debug((Object)"Setting stereo: ", new Object[]{stereo});
        super.setStereo(stereo);
    }

    public Point2d get2DCenter() {
        this.logger.debug((Object)"Getting 2d center: ", new Object[]{super.get2DCenter()});
        return super.get2DCenter();
    }

    public Point3d get3DCenter() {
        this.logger.debug((Object)"Getting 3d center: ", new Object[]{super.get3DCenter()});
        return super.get3DCenter();
    }

    public boolean compare(Object object) {
        this.logger.debug((Object)"Comparing to object: ", new Object[]{object});
        return super.compare(object);
    }

    public boolean isConnectedTo(IBond bond) {
        this.logger.debug((Object)"Is connected to bond: ", new Object[]{bond});
        return super.isConnectedTo(bond);
    }
}

