% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-settime.R, R/op-cdo-setcalendar.R,
%   R/op-cdo-setdate.R, R/op-cdo-setday.R, R/op-cdo-setmon.R,
%   R/op-cdo-setreftime.R, R/op-cdo-settaxis.R, R/op-cdo-settbounds.R,
%   R/op-cdo-settime.R, R/op-cdo-settunits.R, R/op-cdo-setyear.R,
%   R/op-cdo-shifttime.R
\name{settime}
\alias{settime}
\alias{cdo_setcalendar}
\alias{cdo_setdate}
\alias{cdo_setday}
\alias{cdo_setmon}
\alias{cdo_setreftime}
\alias{cdo_settaxis}
\alias{cdo_settbounds}
\alias{cdo_settime}
\alias{cdo_settunits}
\alias{cdo_setyear}
\alias{cdo_shifttime}
\title{Set time}
\usage{
cdo_setcalendar(
  ifile,
  day = NULL,
  month = NULL,
  year = NULL,
  units = NULL,
  date = NULL,
  time = NULL,
  inc = NULL,
  frequency = NULL,
  calendar = NULL,
  shiftValue = NULL,
  ofile = NULL
)

cdo_setdate(
  ifile,
  day = NULL,
  month = NULL,
  year = NULL,
  units = NULL,
  date = NULL,
  time = NULL,
  inc = NULL,
  frequency = NULL,
  calendar = NULL,
  shiftValue = NULL,
  ofile = NULL
)

cdo_setday(
  ifile,
  day = NULL,
  month = NULL,
  year = NULL,
  units = NULL,
  date = NULL,
  time = NULL,
  inc = NULL,
  frequency = NULL,
  calendar = NULL,
  shiftValue = NULL,
  ofile = NULL
)

cdo_setmon(
  ifile,
  day = NULL,
  month = NULL,
  year = NULL,
  units = NULL,
  date = NULL,
  time = NULL,
  inc = NULL,
  frequency = NULL,
  calendar = NULL,
  shiftValue = NULL,
  ofile = NULL
)

cdo_setreftime(
  ifile,
  day = NULL,
  month = NULL,
  year = NULL,
  units = NULL,
  date = NULL,
  time = NULL,
  inc = NULL,
  frequency = NULL,
  calendar = NULL,
  shiftValue = NULL,
  ofile = NULL
)

cdo_settaxis(
  ifile,
  day = NULL,
  month = NULL,
  year = NULL,
  units = NULL,
  date = NULL,
  time = NULL,
  inc = NULL,
  frequency = NULL,
  calendar = NULL,
  shiftValue = NULL,
  ofile = NULL
)

cdo_settbounds(
  ifile,
  day = NULL,
  month = NULL,
  year = NULL,
  units = NULL,
  date = NULL,
  time = NULL,
  inc = NULL,
  frequency = NULL,
  calendar = NULL,
  shiftValue = NULL,
  ofile = NULL
)

cdo_settime(
  ifile,
  day = NULL,
  month = NULL,
  year = NULL,
  units = NULL,
  date = NULL,
  time = NULL,
  inc = NULL,
  frequency = NULL,
  calendar = NULL,
  shiftValue = NULL,
  ofile = NULL
)

cdo_settunits(
  ifile,
  day = NULL,
  month = NULL,
  year = NULL,
  units = NULL,
  date = NULL,
  time = NULL,
  inc = NULL,
  frequency = NULL,
  calendar = NULL,
  shiftValue = NULL,
  ofile = NULL
)

cdo_setyear(
  ifile,
  day = NULL,
  month = NULL,
  year = NULL,
  units = NULL,
  date = NULL,
  time = NULL,
  inc = NULL,
  frequency = NULL,
  calendar = NULL,
  shiftValue = NULL,
  ofile = NULL
)

cdo_shifttime(
  ifile,
  day = NULL,
  month = NULL,
  year = NULL,
  units = NULL,
  date = NULL,
  time = NULL,
  inc = NULL,
  frequency = NULL,
  calendar = NULL,
  shiftValue = NULL,
  ofile = NULL
)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{day}{INTEGER - Value of the new day}

\item{month}{INTEGER - Value of the new month}

\item{year}{INTEGER - Value of the new year}

\item{units}{STRING - Base units of the time axis (seconds|minutes|hours|days|months|years)}

\item{date}{STRING - Date (format: YYYY-MM-DD)}

\item{time}{STRING - Time (format: hh:mm:ss)}

\item{inc}{STRING - Optional increment (seconds|minutes|hours|days|months|years) [default: 1hour]}

\item{frequency}{STRING - Frequency of the time series (hour|day|month|year)}

\item{calendar}{STRING - Calendar (standard|proleptic_gregorian|360_day|365_day|366_day)}

\item{shiftValue}{STRING - Shift value (e.g. -3hour)}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module sets the time axis or part of the time axis. Which part of the time axis is overwritten/created depends on the chosen operator. The number of time steps does not change.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{setdate      Set date
             Sets the date in every timestep to the same given value.
settime      Set time of the day
             Sets the time in every timestep to the same given value.
setday       Set day
             Sets the day in every timestep to the same given value.
setmon       Set month
             Sets the month in every timestep to the same given value.
setyear      Set year
             Sets the year in every timestep to the same given value.
settunits    Set time units
             Sets the base units of a relative time axis.
settaxis     Set time axis
             Sets the time axis.
settbounds   Set time bounds
             Sets the time bounds.
setreftime   Set reference time
             Sets the reference time of a relative time axis.
setcalendar  Set calendar
             Sets the calendar attribute of a relative time axis.
shifttime    Shift timesteps
             Shifts all timesteps by the parameter shiftValue.
}\if{html}{\out{</div>}}
}
