% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.r
\name{get_best}
\alias{get_best}
\title{Get the best submissions per team and per metric.}
\usage{
get_best(history, metrics = names(metrics), test_name = "quiz")
}
\arguments{
\item{history}{list of the submissions history per team as returned by \code{\link{compute_metrics}}}

\item{metrics}{character vector. names of the metrics}

\item{test_name}{string. name of the test set used: \code{"quiz"} or \code{"test"}}
}
\value{
\code{get_best} returns a named list with one member per metric. Each
  memebr is a \code{data.frame} where the rows are teams in decreasing order of performance
  and the columns are:
  \item{team}{name of the team}
  \item{n_submissions}{total number of submissions}
  \item{date}{the date of the best submission}
  \item{file}{the file name of the best submission}
  \item{<metric name>.quiz}{the score obtained on the quiz subset}
  \item{<metric name>.test}{the score obtained on the test set}
  \item{rank}{the rank of the team}
  \item{rank_diff}{the rank difference is set to 0 temporarily.}
}
\description{
Get the best submissions per team and per metric.
}

