% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from_aml.R
\name{from_aml}
\alias{from_aml}
\alias{from_archie}
\title{Import ArchieML data from a string, file, or URL}
\usage{
from_aml(aml, simplifyVector = FALSE,
  simplifyDataFrame = simplifyVector, simplifyMatrix = simplifyVector,
  flatten = FALSE, ...)


}
\arguments{
\item{aml}{a string, file, connection, URL, or  Google Drive ID created by
\link[googledrive:as_id]{googledrive::as_id} from which to read ArchieML. Inputs of length > 1,
with line breaks, or non-existent file names will always be treated as raw
ArchieML.  To read multiple ArchieML inputs use a function such as
\link{lapply}.}

\item{simplifyVector, simplifyDataFrame, simplifyMatrix, flatten}{passed to
\link[jsonlite]{fromJSON} to determine how the JSON generated from is
parsed.  If raw JSON outputs are desired use \link{aml_to_json}}

\item{...}{further arguments to be passed to\link[jsonlite:fromJSON]{jsonlite::fromJSON}, for
class-specific print methods}
}
\value{
A list of class "from_aml"
}
\description{
This imports data from  New York Times' ArchieML format as an R object. Text
is parsed to JSON using
\href{https://github.com/newsdev/archieml-js}{archieml-js}, then imported via
\link[jsonlite:fromJSON]{jsonlite::fromJSON}.
}
\details{
This function was formerly named \code{from_archie}, which is now deprecated.
}
\examples{
from_aml(aml = "key: value")
from_aml("http://archieml.org/test/1.0/arrays.1.aml")

\donttest{\dontrun{
# See source at:
# https://drive.google.com/open?id=1oYHXxvzscBBSBhd6xg5ckUEZo3tLytk9zY0VV_Y7SGs
library(googledrive)
from_aml(as_id("1oYHXxvzscBBSBhd6xg5ckUEZo3tLytk9zY0VV_Y7SGs"))
}}
}
\references{
\url{http://archieml.org/}
}
\seealso{
\link{aml_to_json}
}
