% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwisePermutationMatrix.r
\name{pairwisePermutationMatrix}
\alias{pairwisePermutationMatrix}
\title{Pairwise two-sample independence tests with matrix output}
\usage{
pairwisePermutationMatrix(
  formula = NULL,
  data = NULL,
  x = NULL,
  g = NULL,
  method = "fdr",
  ...
)
}
\arguments{
\item{formula}{A formula indicating the measurement variable and
the grouping variable. e.g. y ~ group.}

\item{data}{The data frame to use.}

\item{x}{The response variable as a vector.}

\item{g}{The grouping variable as a vector.}

\item{method}{The p-value adjustment method to use for multiple tests.
See \code{stats::p.adjust}.}

\item{...}{Additional arguments passed to
\code{coin::independence_test}.}
}
\value{
A list consisting of:
        A matrix of p-values;
        the p-value adjustment method;
        a matrix of adjusted p-values.
}
\description{
Conducts pairwise two-sample independence tests across groups.
}
\details{
The input should include either \code{formula} and \code{data};
         or \code{x}, and \code{g}.

         This function is a wrapper for \code{coin::independence_test},
         passing pairwise groups to the function. It's critical to read
         and understand the documentation for this function to understand
         its use and options.
         
         For some options for common tests, see Horthorn et al., 2008.
}
\note{
The parsing of the formula is simplistic. 
         The first variable on the
         left side is used as the measurement variable.  
         The first variable on the
         right side is used for the grouping variable.
}
\examples{
### Fisher-Pitman test

data(BrendonSmall)

library(coin)
                                 
independence_test(Sodium ~ Instructor, data = BrendonSmall, 
                  teststat = "quadratic") 
                                      
PT = pairwisePermutationMatrix(Sodium ~ Instructor,
                               data     = BrendonSmall,
                               teststat = "quadratic",
                               method   = "fdr")
PT

PA = PT$Adjusted
library(multcompView)
multcompLetters(PA,
                compare="<",
                threshold=0.05,
                Letters=letters)   

}
\references{
\url{http://rcompanion.org/handbook/K_02.html}

            Hothorn, T., K. Hornik, M.A. van de Wiel, and A. Zeileis. 2008. 
            Implementing a Class of Permutation Tests: The coin Package. 
            Journal of Statistical Software, 28(8), 1–23.
}
\seealso{
\code{\link{pairwisePermutationTest}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{permutation test}
\concept{post-hoc}
