% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_citation.R
\name{add_citation}
\alias{add_citation}
\title{Create a CITATION file}
\usage{
add_citation(
  given = NULL,
  family = NULL,
  organisation = NULL,
  open = TRUE,
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{given}{A character of length 1. The given name of the project
maintainer.}

\item{family}{A character of length 1. The family name of the project
maintainer.}

\item{organisation}{A character of length 1. The name of the GitHub
organisation to host the package. If \code{NULL} (default) the GitHub account
will be used. This argument is used to set the URL of the package
(hosted on GitHub).}

\item{open}{A logical value. If \code{TRUE} (default) the file is opened in the
editor.}

\item{overwrite}{A logical value. If this file is already present and
\code{overwrite = TRUE}, it will be erased and replaced. Default is \code{FALSE}.}

\item{quiet}{A logical value. If \code{TRUE} messages are deleted. Default is
\code{FALSE}.}
}
\value{
No return value.
}
\description{
This function creates a \code{CITATION} file in the folder \verb{inst/}. This file
contains a BiBTeX entry to cite the package as a manual. User will need to
edit by hand some information (title, version, etc.).
}
\examples{
\dontrun{
add_citation()
readCitationFile("inst/CITATION")
citation("pkg")    # If you have installed your package <pkg>
}
}
\seealso{
Other create files: 
\code{\link{add_compendium}()},
\code{\link{add_description}()},
\code{\link{add_dockerfile}()},
\code{\link{add_license}()},
\code{\link{add_makefile}()},
\code{\link{add_package_doc}()},
\code{\link{add_readme_rmd}()},
\code{\link{add_renv}()},
\code{\link{add_testthat}()},
\code{\link{add_vignette}()}
}
\concept{create files}
