% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trollsim.R
\name{trollsim}
\alias{trollsim}
\title{An S4 class to represent TROLL simulations}
\usage{
trollsim(
  name = character(),
  path = character(),
  parameters = numeric(),
  inputs = list(),
  log = character(),
  forest = data.frame(),
  ecosystem = data.frame(),
  species = data.frame(),
  las = list()
)
}
\arguments{
\item{name}{char. Simulation name.}

\item{path}{char. Path to the simulation.}

\item{parameters}{numeric. Parameters of the simulation (general inputs).}

\item{inputs}{list. Simulation inputs (species, climate, daily,
forest,lidar).}

\item{log}{chr. Simulation log.}

\item{forest}{df. Simulation initial and final forest.}

\item{ecosystem}{df. Ecosystem metrics.}

\item{species}{df. Species metrics (with OUTPUT_extended option).}

\item{las}{list. List with one simulated point cloud in LAS from lidar
parameters (with lidar option). The LAS format correspond to lidr::LAS.}
}
\value{
An empty S4 \linkS4class{trollsim} class object.
}
\description{
This is an S4 class to represent TROLL simulations.
}
