% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBWindow.R
\name{CMBWindow}
\alias{CMBWindow}
\title{CMBWindow class.}
\usage{
CMBWindow(..., r, set.minus = FALSE, assume.convex = FALSE)
}
\arguments{
\item{...}{these arguments are compulsory and must be labelled either x, y, z
(cartesian) or theta, phi (spherical, colatitude and longitude respectively).
Alternatively, a single data.frame may be passed in with columns labelled
x, y, z or theta, phi.}

\item{r}{if a disc type window is required then this specifies the
radius of the disc}

\item{set.minus}{when \code{TRUE} the window will be the unit
sphere minus the window specified}

\item{assume.convex}{when \code{TRUE} the window is assumed to be convex
resulting in a faster computation time when the window is used with functions
such as \code{\link{subWindow}}. This argument is irrelevant when the window
is not a polygon}
}
\description{
The function \code{CMBWindow} creates objects of class \code{CMBWindow}.
It is either a polygon or a disc type.
}
\details{
If \code{r} is unspecified then the rows of \code{...} correspond to
counter-clockwise ordered vertices defining a spherical polygon
lying entirely within one open hemisphere on the unit sphere.
Counter-clockwise is understood from the perspective outside the
sphere, facing the hemisphere that contains the polygon, looking
toward the origin. Note that there must be at least 3 rows (vertices)
to define a polygon (we exclude bygones).
On the other hand,
if \code{r} is specified then \code{...} must specify just one row, and this
row is taken to be the center of a disc of radius \code{r}
}
\examples{
win <- CMBWindow(theta = c(pi/2,pi/2,pi/3, pi/3), phi = c(0,pi/3,pi/3,0))
plot(win)


## Create a disc type window
win1<- CMBWindow(x=0,y=3/5,z=4/5,r=0.8, set.minus =TRUE)
plot(win1)


## Apply a disc type window to CMBDataFrame
cmbdf <- CMBDataFrame(nside = 64, coords = "cartesian", ordering = "nested")
window(cmbdf) <- CMBWindow(x=0,y=3/5,z=4/5,r=0.8, set.minus =TRUE)
plot(cmbdf)
}
