% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Conversion.R
\name{ring2nest}
\alias{ring2nest}
\title{Convert ring to nest ordering.}
\usage{
ring2nest(nside, pix)
}
\arguments{
\item{nside}{is the HEALPix nside parameter (integer number \eqn{2^k})}

\item{pix}{is a vector of HEALPix pixel indices, in the 'ring' ordering scheme.}
}
\value{
the output is a vector of HEALPix pixel indices in the 'nested'
ordering scheme.
}
\description{
\code{ring2nest} converts HEALPix pixel indices in the 'ring' ordering scheme
 to HEALPix pixel indices in the 'nested' ordering scheme.
}
\examples{
## Convert (1,2,23) from ring to nest at nside = 8
nside <- 8
pix <-c(1,2,23)
ring2nest(nside,pix)

}
