% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{plot.CMBCovariance}
\alias{plot.CMBCovariance}
\title{Plot sample CMBCovariance}
\usage{
\method{plot}{CMBCovariance}(x, ...)
}
\arguments{
\item{x}{An object of class CMBCovariance.}

\item{...}{Extra arguments as in \code{\link[geoR]{plot.variogram}} passed to plot.default.}
}
\value{
Produces a plot with the sample covariance function.

#'@references \strong{geoR} package, \code{\link{covCMB}}, \code{\link[geoR]{variog}},
\code{\link[geoR]{plot.variogram}}
}
\description{
Plots sample (empirical) covariance function. Uses \code{\link[geoR]{plot.variogram}} from
\strong{geoR} package.
}
\examples{

## Download the map first
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits")
# cmbdf <- sampleCMB(df, sample.size = 100000)
# Cov <- covCMB(cmbdf, max.dist = 0.03, num.bins = 10)
# plot(Cov)

}
