% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials_functions.r,
%   R/credentials_functions_DB_specific.r
\name{credentials_functions}
\alias{credentials_functions}
\alias{write_credentials_to_file}
\alias{read_credentials_from_file}
\alias{read_db_credentials_from_file}
\alias{write_db_credentials_to_file}
\title{Credentials Functions}
\usage{
write_credentials_to_file(..., file_full_path = "..auto..",
  info.file_name = "", file_name = getOption("rcreds.file_name", default =
  ".credentials.creds"), folder = get_default_rcreds_folder(DB = FALSE),
  allow_root_user = FALSE, zArchive_existing = TRUE,
  overwrite_existing = FALSE, key = read_key_from_file(),
  showWarnings = TRUE, verbose = getOption("verbose.rcreds", default =
  TRUE))

read_credentials_from_file(file_full_path = "..auto..", info.file_name = "",
  file_name = getOption("rcreds.file_name", default = ".credentials.creds"),
  folder = get_default_rcreds_folder(DB = FALSE),
  key = read_key_from_file(), fail_if_cant_decrypt = TRUE,
  showWarnings = TRUE, verbose = getOption("verbose.rcreds", default =
  TRUE))

read_db_credentials_from_file(file_full_path = "..auto..",
  info.file_name = "", file_name = getOption("rcreds.db.file_name", default
  = ".db_credentials.creds"), folder = get_default_rcreds_folder(DB = TRUE),
  key = read_key_from_file(), fail_if_cant_decrypt = TRUE,
  showWarnings = TRUE, verbose = getOption("verbose.rcreds", default =
  TRUE))

write_db_credentials_to_file(dbname = "dev", host = "localhost",
  port = 5432, username = "you_forgot_to_specify_username",
  password = "too_many_secrets", file_full_path = "..auto..",
  info.file_name = "", file_name = getOption("rcreds.db.file_name", default
  = ".db_credentials.creds"), folder = get_default_rcreds_folder(DB = TRUE),
  allow_root_user = FALSE, zArchive_existing = TRUE,
  overwrite_existing = FALSE, key = read_key_from_file(), ...,
  verbose = getOption("verbose.rcreds", default = TRUE))
}
\arguments{
\item{...}{values to be encrypted and written to the credentials file. 
           if named parameters, the list which is outputed by \code{read_credentials_from_file} will use those same names.

           if empty in \code{write_credentials_to_file} then nothing will be written to disk in the credentials file}

\item{file_full_path}{The full path to the creds (or key) file, where it should be read from or written to. 
    if \code{"..auto.."} then will be constructed from \code{folder}, \code{file_name}, and \code{info.file_name}
    
    NOTE: When \code{file_full_path} is set explicitly, then \code{folder}, \code{file_name}, and \code{info.file_name} are ignored.

                      Defaults to: "..auto.."}

\item{info.file_name}{Will be added as a prefix to the filename. 

Useful when using multiple files in a given folder. 

                      Defaults to: "\\"\\""}

\item{file_name}{name of the file where the credentials will be written to or read from.  Should be a string of length 1

                 Defaults to: getOption(\\"rcreds.file_name\\", default = \\".credentials.creds\\")}

\item{folder}{folder where the credentials will be written to or read from.

              Defaults to: get_default_rcreds_folder(DB=FALSE)}

\item{allow_root_user}{A TRUE/FALSE flag.  If FALSE and user is root, then writing and saving functions will fail
                    This is a safety to make sure the user understands they are operating under root.

                         Defaults to: FALSE}

\item{zArchive_existing}{A TRUE/FALSE flag.  If \code{file_full_path} already exist, should it be moved to a zArchive folder?

                         Defaults to: TRUE}

\item{overwrite_existing}{A TRUE/FALSE flag.  If \code{file_full_path} already exist, should it be overwritten? This is only considered when \code{zArchive_existing} is FALSE

                          Defaults to: FALSE}

\item{key}{A key object of class \code{"key_rcreds"} to be used for encrypting / decrypting. Passed to \code{digest::AES}.

                Alternatively, a full file path to a key stored on disk can be given which will be read to disk.

           Defaults to: read_key_from_file()}

\item{showWarnings}{A TRUE/FALSE flag.  If FALSE, warnings will be silenced

                          Defaults to: TRUE}

\item{verbose}{A TRUE/FALSE flag.

               Defaults to: getOption(\\"verbose.rcreds\\", default = TRUE)

Details

The \code{write_..} functions take a list of parameters along with a key object, encrypt the parameters and write them to a file on disk.

The \code{read_..} functions read said file, and given (the same) key object, decrypt the parameters and return a named list. 

The corresponding \code{.._db_..} files are wrappers that explicitly list the main five parameters used for database connections, with comonly used defaults. Namely, \code{host}, \code{username}, \code{password}, \code{port}, and \code{database}.}

\item{fail_if_cant_decrypt}{A TRUE/FALSE flag.  If set to TRUE, the reading functions will fail on error. If set to FALSE, NULL will be returned and a graceful exit will happen (with a possible warning if \code{showWarnings} is TRUE.

                          Defaults to: TRUE}

\item{dbname}{parameter for database connections. Will be encrypted and written to database

              Defaults to: "dev"}

\item{host}{parameter for database connections. Will be encrypted and written to database

            Defaults to: "localhost"}

\item{port}{parameter for database connections. Will be encrypted and written to database

            Defaults to: 5432}

\item{username}{parameter for database connections. Will be encrypted and written to database

                Defaults to: "you_forgot_to_specify_username"}

\item{password}{parameter for database connections. Will be encrypted and written to database

                Defaults to: "too_many_secrets"}
}
\value{
for \code{write_credentials_to_file} and \code{write_db_credentials_to_file} The file path where the encrypted values have been stored, reutrned invisibly. ie the value of \code{file_full_path}

for \code{read_credentials_from_file} and \code{read_db_credentials_from_file} a named list of the values stored in the credentials file. The names of the list correspond to the names of the argument passed to the corresponding write functions
}
\description{
Securely Write/Read Sensitive Parameters to/from Disk
}
\details{
#' There are two sets of pairs of functions
use \code{write_credentials_to_file()} to output to disk
use \code{read_credentials_from_file()} to read in the credentials back to R

Similarly, there are a pair of functions with the 5 comonly-used parameters for database connections
use \code{write_db_credentials_to_file()} and \code{read_db_credentials_from_file()}
}
\examples{

 \dontrun{
   library(rcreds)
 
   some_login_function <- function(username, password) {
     ## does something with username/password
     ## ... 
   }
 
   ### ---------------------------------------------- ###
   ## Default Folders need to be set. This shold be in an .Rprofile file
   ### ---------------------------------------------- ###
   ## generally use:  set_default_rcreds_ALL(parent_folder = "~/.rcreds/")
   set_default_rcreds_ALL(parent_folder = file.path(tempdir(), ".rcreds/"), 
                          create_if_not_exist = TRUE)
   ### ---------------------------------------------- ###
 
   ## ONE TIME, DO NOT SAVE THIS 
   write_db_credentials_to_file(username="cosmo", password="still too many secrets"
                              , port=1234, host="ec2-1234-567-89.us-west.compute.amazonaws.com")
 
 
   ## SEPARATELY, in a new file:
   credentials_list <- read_db_credentials_from_file(fail_if_cant_decrypt=FALSE, showWarnings=FALSE)
   ## normally, leave the above flags as their default TRUE. Using FALSE for this example only.
 
   some_login_function(username = credentials_list$user_name
                     , password = credentials_list$password
                      )
 }


}
