% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{clean_network}
\alias{clean_network}
\title{Clean a spatial network.}
\usage{
clean_network(network, simplify = TRUE)
}
\arguments{
\item{network}{A network object}

\item{simplify}{Whether the network should be simplified with
\code{\link[=simplify_network]{simplify_network()}}}
}
\value{
A cleaned network object
}
\description{
Subdivide edges by \href{https://luukvdmeer.github.io/sfnetworks/articles/sfn02_preprocess_clean.html#subdivide-edges}{adding missing nodes},
(optionally) simplify the network (see \code{\link[=simplify_network]{simplify_network()}}), remove
\href{https://luukvdmeer.github.io/sfnetworks/articles/sfn02_preprocess_clean.html#smooth-pseudo-nodes}{pseudo-nodes},
and discard all but the main connected component.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucharest_osm <- get_osm_example_data()
edges <- dplyr::bind_rows(bucharest_osm$streets,
                          bucharest_osm$railways)
network <- sfnetworks::as_sfnetwork(edges, directed = FALSE)
clean_network(network)
\dontshow{\}) # examplesIf}
}
