% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmdata.R
\name{get_osm_buildings}
\alias{get_osm_buildings}
\title{Get OpenStreetMap buildings}
\usage{
get_osm_buildings(aoi, crs = NULL, force_download = FALSE)
}
\arguments{
\item{aoi}{Area of interest as sf object or bbox}

\item{crs}{Coordinate reference system as EPSG code}

\item{force_download}{Download data even if cached data is available}
}
\value{
An sf object with the buildings
}
\description{
Get buildings from OpenStreetMap within a given buffer around a river.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bb <- get_osm_bb("Bucharest")
crs <- get_utm_zone(bb)
get_osm_buildings(bb, crs)
\dontshow{\}) # examplesIf}
}
