% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valley.R
\name{load_dem}
\alias{load_dem}
\title{Retrieve DEM data from a list of STAC assets}
\usage{
load_dem(bb, tile_urls, force_download = FALSE)
}
\arguments{
\item{bb}{A bounding box, provided either as a matrix (rows for "x", "y",
columns for "min", "max") or as a vector ("xmin", "ymin", "xmax", "ymax")}

\item{tile_urls}{A list of tiles where to read the DEM data from}

\item{force_download}{Download data even if cached data is available}
}
\value{
Raster DEM, retrieved and retiled to the given bounding box
}
\description{
Load DEM data from a list of tiles, crop and merge using a given bounding
box to create a raster DEM for the specified region. Results are cached, so
that new queries with the same input parameters will be loaded from disk.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bb <- get_osm_bb("Bucharest")
tile_urls <- get_stac_asset_urls(bb)
load_dem(bb, tile_urls)
\dontshow{\}) # examplesIf}
}
