% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BetaModVar.R
\docType{class}
\name{BetaModVar}
\alias{BetaModVar}
\title{A model variable whose uncertainty follows a Beta distribution}
\description{
An R6 class representing a model variable whose uncertainty
is described by a Beta distribution.
}
\details{
A model variable for which the uncertainty in the point estimate can
be modelled with a Beta distribution. The hyperparameters of the
distribution are the shape parameters (\code{alpha} and \code{beta}) of
the uncertainty distribution. Inherits from class \code{ModVar}.
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:ModVar]{rdecision::ModVar}} -> \code{BetaModVar}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BetaModVar-new}{\code{BetaModVar$new()}}
\item \href{#method-BetaModVar-is_probabilistic}{\code{BetaModVar$is_probabilistic()}}
\item \href{#method-BetaModVar-clone}{\code{BetaModVar$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="SD"><a href='../../rdecision/html/ModVar.html#method-ModVar-SD'><code>rdecision::ModVar$SD()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="description"><a href='../../rdecision/html/ModVar.html#method-ModVar-description'><code>rdecision::ModVar$description()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="distribution"><a href='../../rdecision/html/ModVar.html#method-ModVar-distribution'><code>rdecision::ModVar$distribution()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="get"><a href='../../rdecision/html/ModVar.html#method-ModVar-get'><code>rdecision::ModVar$get()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="is_expression"><a href='../../rdecision/html/ModVar.html#method-ModVar-is_expression'><code>rdecision::ModVar$is_expression()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="mean"><a href='../../rdecision/html/ModVar.html#method-ModVar-mean'><code>rdecision::ModVar$mean()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="mode"><a href='../../rdecision/html/ModVar.html#method-ModVar-mode'><code>rdecision::ModVar$mode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="quantile"><a href='../../rdecision/html/ModVar.html#method-ModVar-quantile'><code>rdecision::ModVar$quantile()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="r"><a href='../../rdecision/html/ModVar.html#method-ModVar-r'><code>rdecision::ModVar$r()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="set"><a href='../../rdecision/html/ModVar.html#method-ModVar-set'><code>rdecision::ModVar$set()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="units"><a href='../../rdecision/html/ModVar.html#method-ModVar-units'><code>rdecision::ModVar$units()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BetaModVar-new"></a>}}
\if{latex}{\out{\hypertarget{method-BetaModVar-new}{}}}
\subsection{Method \code{new()}}{
Create an object of class \code{BetaModVar}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BetaModVar$new(description, units, alpha, beta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{description}}{A character string describing the variable.}

\item{\code{units}}{Units of the variable, as character string.}

\item{\code{alpha}}{parameter of the Beta distribution.}

\item{\code{beta}}{parameter of the Beta distribution.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{BetaModVar}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BetaModVar-is_probabilistic"></a>}}
\if{latex}{\out{\hypertarget{method-BetaModVar-is_probabilistic}{}}}
\subsection{Method \code{is_probabilistic()}}{
Tests whether the model variable is probabilistic,
i.e. a random variable that follows a distribution, or an expression
involving random variables, some of which follow distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BetaModVar$is_probabilistic()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if probabilistic
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BetaModVar-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BetaModVar-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BetaModVar$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
