% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReconciliationReportRowService.R
\name{dfp_getReconciliationReportRowsByStatement}
\alias{dfp_getReconciliationReportRowsByStatement}
\title{ReconciliationReportRowService}
\usage{
dfp_getReconciliationReportRowsByStatement(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getReconciliationReportRowsByStatementResponse
}
\description{
Provides methods for retrieving and updating the ReconciliationReportRow
objects.
}
\details{
getReconciliationReportRowsByStatement

Gets a ReconciliationReportRowPage of ReconciliationReportRow objects that satisfy the given Statement query. The following fields are supported for filtering: 
\itemize{
  \item{reconciliationReportId}
  \item{advertiserId}
  \item{orderId}
  \item{lineItemId}
  \item{proposalLineItemId}
  \item{creativeId}
  \item{lineItemCostType}
  \item{dfpClicks}
  \item{dfpImpressions}
  \item{dfpLineItemDays}
  \item{thirdPartyClicks}
  \item{thirdPartyImpressions}
  \item{thirdPartyLineItemDays}
  \item{manualClicks}
  \item{manualImpressions}
  \item{manualLineItemDays}
  \item{reconciledClicks}
  \item{reconciledImpressions}
  \item{reconciledLineItemDays}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getReconciliationReportRowsByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/ReconciliationReportRowService#getReconciliationReportRowsByStatement}{Google Documentation for getReconciliationReportRowsByStatement}
}
