\name{rdplot}
\alias{rdplot}
\alias{print.rdplot}
\alias{summary.rdplot}
\title{Data-Driven Regression Discontinuity Plots}
\description{

\code{\link{rdplot}}  implements several data-driven Regression Discontinuity (RD) plots, using either evenly-spaced or quantile-spaced partitioning. Two type of RD plots are constructed: (i) RD plots with binned sample means tracing out the underlying regression function, and (ii) RD plots with binned sample means mimicking the underlying variability of the data. For technical and methodological details see Calonico, Cattaneo and Titiunik (2015a).

Companion commands are: \code{\link{rdrobust}} for point estimation and inference procedures, and \code{\link{rdbwselect}} for data-driven bandwidth selection.

A detailed introduction to this command is given in Calonico, Cattaneo and Titiunik (2015b) and Calonico, Cattaneo, Farrell and Titiunik (2016). A companion \code{Stata} package is described in Calonico, Cattaneo and Titiunik (2014).

For more details, and related Stata and R packages useful for analysis of RD designs, visit \url{https://sites.google.com/site/rdpackages/}
}
\usage{
rdplot(y, x, subset = NULL, c = 0, p = 4, nbins = NULL, binselect = "esmv",  scale = NULL,
          kernel = "uni", weights = NULL, h = NULL, hide = FALSE, ci = NULL, 
          shade = FALSE, par = NULL, title = NULL, x.label = NULL, y.label = NULL, 
          x.lim = NULL, y.lim = NULL, col.dots = NULL, col.lines = NULL, 
          type.dots = NULL,...)
}
\arguments{
  \item{y}{is the dependent variable.}
  \item{x}{is the running variable (a.k.a. score or forcing variable).}
  \item{subset}{an optional vector specifying a subset of observations to be used.}
  \item{c}{specifies the RD cutoff in \code{x}; default is \code{c = 0}.}
  \item{p}{specifies the order of the global-polynomial used to approximate the population conditional mean functions for control and treated units; default is \code{p = 4}.} 
  
  \item{kernel}{specifies the kernel function used to construct the local-polynomial estimator(s). Options are: \code{triangular}, \code{epanechnikov}, and \code{uniform}. Default is \code{kernel=uniform} (i.e., equal/no weighting to all observations on the support of the kernel).}
  \item{weights}{is the variable used for optional weighting of the estimation procedure. The unit-specific weights multiply the kernel function.}
\item{h}{specifies the bandwidth used to construct the (global) polynomial fits given the kernel choice \code{kernel}.
If not specified, the bandwidths are chosen to span the full support of the data. If two bandwidths are specified, the first bandwidth is used for the data below the cutoff and the second bandwidth is used for the data above the cutoff.}

  \item{nbins}{specifies the number of bins used to the left of the cutoff, denoted \eqn{J_-}, and to the right of the cutoff, denoted \eqn{J_+}, respectively. If not specified, \eqn{J_+} and \eqn{J_-} are estimated using the method and options chosen below.}

\item{binselect}{specifies the procedure to select the number of bins. This option is available only if \eqn{J_-} and \eqn{J_+} are not set manually. Options are:  

        \code{es}: IMSE-optimal evenly-spaced method using spacings estimators.
        
        \code{espr}: IMSE-optimal evenly-spaced method using polynomial regression.
        
        \code{esmv}: mimicking variance evenly-spaced method using spacings estimators. This is the default option.
        
        \code{esmvpr}: mimicking variance evenly-spaced method using polynomial regression.
        
        \code{qs}: IMSE-optimal quantile-spaced method using spacings estimators.
        
        \code{qspr}: IMSE-optimal quantile-spaced method using polynomial regression.
        
        \code{qsmv}: mimicking variance quantile-spaced method using spacings estimators.
        
        \code{qsmvpr}: mimicking variance quantile-spaced method using polynomial regression.
     }

  \item{scale}{specifies a multiplicative factor to be used with the optimal numbers of bins selected. Specifically, the number of bins used for the treatment and control groups will be \code{scale}\eqn{\times \hat{J}_+} and \code{scale}\eqn{\times \hat{J}_-}, where \eqn{\hat{J}_\cdot} denotes the estimated optimal numbers of bins originally computed for each group; default is \code{scale = 1}.}
  \item{hide}{logical. If \code{TRUE}, it omits the RD plot; default is \code{hide = FALSE}.}
  \item{ci}{optional graphical option to display confidence intervals of selected level for each bin.}
  \item{shade}{optional graphical option to replace confidence intervals with shaded areas.}
  \item{par}{optional graphical parameters.}
  \item{title}{optional title for the RD plot.}
  \item{x.label}{optional label for the x-axis of the RD plot.}
  \item{y.label}{optional label for the y-axis of the RD plot.}
  \item{x.lim}{optional setting for the range of the x-axis in the RD plot.}
  \item{y.lim}{optional setting for the range of the y-axis in the RD plot.}
  \item{col.dots}{optional setting for the color of the dots in the RD plot.}
  \item{col.lines}{optional setting for the color of the lines in the RD plot.}
  \item{type.dots}{optional setting for the type of lines in the RD plot.}
  \item{...}{other graphical parameters.}
}
\value{
  \item{method}{method used to compute the optimal number of bins.}
  \item{results}{matrix containing the main estimation results (sample size, polynomial order, number of bins, scales and bin lengths).}
  \item{coef}{matrix containing the coefficients of the \eqn{p^{th}} order global polynomial estimated both sides of the cutoff.}
}
\references{

Calonico, S., M. D. Cattaneo, M. H. Farrell, and R. Titiunik. 2016. Regression Discontinuity Designs using Covariates. Working Paper.
\url{http://www-personal.umich.edu/~cattaneo/papers/Calonico-Cattaneo-Farrell-Titiunik_2016_wp.pdf}.

Calonico, S., M. D. Cattaneo, and R. Titiunik. 2014. Robust Data-Driven Inference in the Regression-Discontinuity Design. Stata Journal 14(4): 909-946.
\url{http://www-personal.umich.edu/~cattaneo/papers/Calonico-Cattaneo-Titiunik_2014_Stata.pdf}.

Calonico, S., M. D. Cattaneo, and R. Titiunik. 2015a. Optimal Data-Driven Regression Discontinuity Plots. Journal of the American Statistical Association 110(512): 1753-1769.
\url{http://www-personal.umich.edu/~cattaneo/papers/Calonico-Cattaneo-Titiunik_2015_JASA.pdf}.

Calonico, S., M. D. Cattaneo, and R. Titiunik. 2015b. rdrobust: An R Package for Robust Nonparametric Inference in Regression-Discontinuity Designs. R Journal 7(1): 38-51.
\url{http://www-personal.umich.edu/~cattaneo/papers/Calonico-Cattaneo-Titiunik_2015_R.pdf}.

Cattaneo, M. D., B. Frandsen, and R. Titiunik. 2015. Randomization Inference in the Regression Discontinuity Design: An Application to the Study of Party Advantages in the U.S. Senate. Journal of Causal Inference 3(1): 1-24.
\url{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Frandsen-Titiunik_2015_JCI.pdf}.
    
        
}
\author{
Sebastian Calonico, University of Miami, Coral Gables, FL.  \email{scalonico@bus.miami.edu}.

Matias D. Cattaneo, University of Michigan, Ann Arbor, MI.  \email{cattaneo@umich.edu}.

Max H. Farrell, University of Chicago, Chicago, IL. \email{max.farrell@chicagobooth.edu}.

Rocio Titiunik, University of Michigan, Ann Arbor, MI.  \email{titiunik@umich.edu}.
}
\examples{
x<-runif(1000,-1,1)
y<-5+3*x+2*(x>=0)+rnorm(1000)
rdplot(y,x)
}
\keyword{ regression discontinuity }
\keyword{ RD plots }
\keyword{ binning }
\keyword{ partitioning}
\keyword{ tuning parameter selection}
\seealso{
  \code{\link{rdbwselect}}, \code{\link{rdrobust}}
}