% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\docType{data}
\name{geoIndex}
\alias{geoIndex}
\alias{geoIndexAll}
\title{coordinatewise station info (meta data) available on the DWD CDC FTP server}
\format{data.frame with ca 7k rows for 9 columns:
        \code{id}, \code{name}, \code{state}
        \code{lat}, \code{long}, \code{ele}
        \code{all_elev}, \code{nfiles_coord}, \code{nfiles_id}}
\source{
Deutscher WetterDienst / Climata Data Center  FTP Server
}
\description{
\code{\link{metaIndex}} distilled to geographic locations.
\code{geoIndexAll} contains all coordinates.
\code{geoIndex} is an aggregated version where stations (of a single ID) with all unique
coordinates less than 900 m apart are aggregated into one location.
Distance is computed with \url{https://github.com/brry/OSMscale/blob/master/R/maxEarthDist.R}
To reduce package dependency, aggregation is done locally in the last section of
\url{https://github.com/brry/rdwd/blob/master/R/meta.R}
}
\examples{

data(geoIndex)
head(geoIndex)
# in functions, you can use head(rdwd:::geoIndex)

# example usages are in ?rdwd

}
\seealso{
\code{\link{metaIndex}}, \code{\link{createIndex}},
        \code{vignette("mapDWD")}, \url{../doc/mapDWD.html}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, June-Nov 2016 + Feb 2017
}
\keyword{datasets}
