% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_elements.R
\name{add_source}
\alias{add_source}
\title{Add a source below a reactable table}
\usage{
add_source(
  table = NULL,
  source = NULL,
  align = "left",
  font_color = "#000",
  font_family = "-apple-system,BlinkMacSystemFont,Helvetica,Arial,sans-serif",
  font_size = 16,
  font_style = "normal",
  font_weight = "normal",
  text_decoration = NULL,
  background_color = "#FFFFFF",
  margin = 4
)
}
\arguments{
\item{table}{A reactable table.}

\item{source}{A string to be displayed as the source.}

\item{align}{The alignment of the source.
Options are "left", "right", "center".
Default is "left".}

\item{font_color}{Color of the source text.
Default is #000.}

\item{font_family}{Font family of the source.
Default is -apple-system, BlinkMacSystemFont, Helvetica, Arial, sans-serif.}

\item{font_size}{Numeric value representing the size of the font of the source (in px).
Default is 16.}

\item{font_style}{Style of the source font.
Options are "normal" or "italic".
Default is "normal".}

\item{font_weight}{The font weight of the source.
Options are "bold" or "normal".
Default is "normal".}

\item{text_decoration}{Optionally add an underline, overline, or line-through source.
Options are "underline", "overline", "underline overline", or "line-through".
Default is NULL.}

\item{background_color}{Color of the source background.
Default is #FFFFFF.}

\item{margin}{Numeric value representing the four-sided margin around the source (in px).
Default is 4.}
}
\value{
a function that adds a source below a reactable table.
}
\description{
Use `add_source()` to place a source below a {reactable} or {reactablefmtr} table.
     The same options that are present in `add_title()` and `add_subtitle()` are also available in `add_source()`.
     The source can be aligned to the left, right, or center with the align option.
     The text properties of the source, such as the font size, font family, and font style can be customized.
     The background color of the source can also be adjusted as well as the margin around the source.
}
\examples{
\dontrun{
## Create the reactable table and then pipe in the source
table <- reactable(iris[10:29, ])

table \%>\%
  add_source("This is a source")

## Use options to adjust the style and position of the source
table \%>\%
  add_source("This is a source", font_style = "italic", font_color = "grey")
}
}
