% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.dbc.R
\name{read.dbc}
\alias{read.dbc}
\title{Read Data Stored in DBC (Compressed DBF) Files}
\usage{
read.dbc(file, ...)
}
\arguments{
\item{file}{The name of the DBC file (including extension)}

\item{...}{Further arguments to be passed to \code{\link{read.dbf}}}
}
\value{
A data.frame of the data from the DBC file.
}
\description{
This function allows you to read a DBC (compressed DBF) file into a data frame. Please note that this is the file format used by the Brazilian Ministry of Health (DATASUS), and it is not related to the FoxPro or CANdb DBC file formats.
}
\details{
DBC is the extension for compressed DBF files (from the 'XBASE' family of databases). This is a proprietary file format used by the brazilian government to make available public healthcare datasets (by it's agency called DATASUS).
\code{read.dbc} relies on the \code{\link{dbc2dbf}} function to decompress the DBC into a temporary DBF file.

After decompressing, it reads the temporary DBF file into a \code{data.frame} using \code{\link{read.dbf}} from the \code{foreign} package.
}
\note{
DATASUS is the name of the Department of Informatics of the Brazilian Health System and is resposible for publishing public healthcare data. Besides the DATASUS, the Brazilian National Agency for Supplementary Health (ANS) also uses this file format for its public data.

This function was tested using files from both DATASUS and ANS to ensure compliance with the format, and hence ensure its usability by researchers.

As a final note, neither this project, nor its author, has any association with the brazilian government.
}
\examples{
# The 'sids.dbc' file is the compressed version of 'sids.dbf' from the "foreign" package.
file <- system.file("files/sids.dbc", package="read.dbc")
sids <- read.dbc(file)
str(sids)
summary(sids)

# This is a small subset of U.S. NOAA storm database.
file <- system.file("files/storm.dbc", package="read.dbc")
storm <- read.dbc(file)
head(storm)
str(storm)

}
\seealso{
\code{\link{dbc2dbf}}
}
\author{
Daniela Petruzalek, \email{daniela.petruzalek@gmail.com}
}
\keyword{datasus}
\keyword{dbc}
