% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitMultiblockDX.R
\name{splitMultiblockDX}
\alias{splitMultiblockDX}
\title{Split a Multiblock JCAMP-DX File into Individual Files}
\usage{
splitMultiblockDX(file = NULL)
}
\arguments{
\item{file}{Length one character giving the name of the multiblock file.}
}
\value{
A list is returned invisibly that has one DX data set per list element.  \pkg{Individual files
       are written into the current directory, so you probably want to work on a copy of the data
       for this task}.  File names are extracted from the
       \code{##TITLE= sample_name} field and will be \code{sample_name} (more precisely,
       the name will be whatever follows \code{##TITLE=} on the line).  If
       sample names are duplicated the output files will be overwritten as the file
       is processed (with a warning).  In this case you should open the multiblock file in a plain text
       editor and search for \code{##TITLE=}, then edit the names to be unique before
       running this function.  Also, you should ensure that \code{sample_name} will
       result in a valid file name on your operating system.
}
\description{
Process a multiblock JCAMP-DX file into separate files, one for each data set.
}
\section{Warning}{

\pkg{Individual data sets are written into the current directory, so you probably want to
work on a copy of the data for this task}.
}

\author{
Bryan A. Hanson, DePauw University.
}
\keyword{file}
\keyword{utilities}
